/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.output.rgb;

import com.google.common.base.Functions;
import io.vavr.control.Either;
import java.util.function.Function;
import java.util.stream.Stream;
import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.spatial.Padding;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.merge.ObjectMaskMerger;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.io.object.output.rgb.ObjectsAsRGBGenerator;
import org.anchoranalysis.image.io.stack.ConvertStackToRGB;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.overlay.bean.DrawObject;
import org.anchoranalysis.overlay.writer.ObjectDrawAttributes;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.Tuple3i;

public class DrawCroppedObjectsGenerator
extends ObjectsAsRGBGenerator {
    private final Padding padding;
    private BoundingBox box;

    public DrawCroppedObjectsGenerator(DrawObject drawObject, DisplayStack background, Padding padding, ColorIndex colors) {
        super(drawObject, new ObjectDrawAttributes(colors), (Either<Dimensions, DisplayStack>)Either.right((Object)background));
        this.padding = padding;
    }

    @Override
    protected RGBStack generateBackgroundRegion(ObjectCollectionWithProperties objects, Either<Dimensions, DisplayStack> background) throws CreateException {
        Extent extent = ((Dimensions)background.fold((Function)Functions.identity(), DisplayStack::dimensions)).extent();
        if (objects.isEmpty()) {
            throw new CreateException("This generator expects at least one object to be present");
        }
        this.box = ObjectMaskMerger.mergeBoundingBoxes((Stream)objects.withoutProperties().streamStandardJava());
        this.box = this.calculateBoxIncludingPadding(this.box, extent);
        return (RGBStack)background.fold(dimensions -> DrawCroppedObjectsGenerator.createEmptyStackFor(new Dimensions(this.box.extent())), stack -> ConvertStackToRGB.convertCropped(stack, this.box));
    }

    @Override
    protected ObjectCollectionWithProperties generateMasks(ObjectCollectionWithProperties objects) throws CreateException {
        return DrawCroppedObjectsGenerator.relativeTo(objects.withoutProperties(), this.box);
    }

    private BoundingBox calculateBoxIncludingPadding(BoundingBox box, Extent containingExtent) {
        if (this.padding.hasNoPadding()) {
            return box;
        }
        return box.growBy((Tuple3i)this.padding.asPoint(), containingExtent);
    }

    private static ObjectCollectionWithProperties relativeTo(ObjectCollection objects, BoundingBox source) {
        ObjectCollectionWithProperties out = new ObjectCollectionWithProperties(objects.size());
        for (ObjectMask objectMask : objects) {
            BoundingBox boxNew = BoundingBox.createReuse((ReadableTuple3i)objectMask.boundingBox().relativePositionTo(source), (Extent)objectMask.boundingBox().extent());
            out.add(new ObjectMask(boxNew, objectMask.binaryVoxels().voxels(), objectMask.binaryValues()));
        }
        return out;
    }
}

