/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.output.rgb;

import io.vavr.control.Either;
import java.util.function.Function;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedByte;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.overlay.bean.DrawObject;
import org.anchoranalysis.overlay.writer.ObjectDrawAttributes;

public abstract class ObjectsAsRGBGenerator
extends RasterGeneratorSelectFormat<ObjectCollectionWithProperties> {
    private static final ChannelFactorySingleType CHANNEL_FACTORY = new ChannelFactoryUnsignedByte();
    private final DrawObject drawObject;
    private final ObjectDrawAttributes attributes;
    private Either<Dimensions, DisplayStack> background;

    public Stack transform(ObjectCollectionWithProperties element) throws OutputWriteFailedException {
        try {
            if (this.background == null) {
                throw new OutputWriteFailedException("No background has been set, as is needed by this generator");
            }
            RGBStack backgroundRegion = this.generateBackgroundRegion(element, this.background);
            this.drawObject.drawCollection(this.generateMasks(element), backgroundRegion, this.attributes);
            return backgroundRegion.asStack();
        }
        catch (CreateException | OperationFailedException e) {
            throw new OutputWriteFailedException(e);
        }
    }

    @Override
    public StackWriteAttributes guaranteedImageAttributes() {
        return StackWriteAttributesFactory.rgb(this.isBackground2D(), false);
    }

    protected abstract RGBStack generateBackgroundRegion(ObjectCollectionWithProperties var1, Either<Dimensions, DisplayStack> var2) throws CreateException;

    protected abstract ObjectCollectionWithProperties generateMasks(ObjectCollectionWithProperties var1) throws CreateException;

    protected static RGBStack createEmptyStackFor(Dimensions dimensions) {
        return new RGBStack(dimensions, CHANNEL_FACTORY);
    }

    private boolean isBackground2D() {
        return ((Dimensions)this.background.fold(Function.identity(), DisplayStack::dimensions)).z() == 1;
    }

    public ObjectsAsRGBGenerator(DrawObject drawObject, ObjectDrawAttributes attributes, Either<Dimensions, DisplayStack> background) {
        this.drawObject = drawObject;
        this.attributes = attributes;
        this.background = background;
    }

    public Either<Dimensions, DisplayStack> getBackground() {
        return this.background;
    }

    public void setBackground(Either<Dimensions, DisplayStack> background) {
        this.background = background;
    }
}

