/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack;

import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.spatial.box.BoundingBox;

public class ConvertStackToRGB {
    public static RGBStack convert(Stack stack, StackDisplayer displayer, boolean alwaysNew) throws CreateException {
        return ConvertStackToRGB.convert(displayer.deriveFrom(stack), alwaysNew);
    }

    public static RGBStack convert(DisplayStack stack, boolean alwaysNew) {
        try {
            if (stack.getNumberChannels() == 1) {
                return new RGBStack(stack.createChannel(0, alwaysNew), stack.createChannel(0, alwaysNew), stack.createChannel(0, alwaysNew));
            }
            return new RGBStack(stack.createChannel(0, alwaysNew), stack.createChannel(1, alwaysNew), stack.createChannel(2, alwaysNew));
        }
        catch (IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    public static RGBStack convertCropped(DisplayStack stack, BoundingBox box) {
        try {
            if (stack.getNumberChannels() == 1) {
                Channel channel = stack.extractChannelForBoundingBox(0, box);
                return new RGBStack(channel, channel.duplicate(), channel.duplicate());
            }
            return new RGBStack(stack.extractChannelForBoundingBox(0, box), stack.extractChannelForBoundingBox(1, box), stack.extractChannelForBoundingBox(2, box));
        }
        catch (IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    private ConvertStackToRGB() {
    }
}

