/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.input;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.core.stack.ImagePyramidMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.input.ImageTimestampsAttributes;
import org.anchoranalysis.image.io.stack.time.TimeSeries;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

public interface OpenedImageFile
extends AutoCloseable {
    default public TimeSeries openCheckType(int seriesIndex, VoxelDataType channelDataType, Logger logger) throws ImageIOException {
        TimeSeries series = this.open(seriesIndex, logger);
        if (!series.allChannelsHaveType(channelDataType)) {
            throw new ImageIOException(String.format("File does not have dataType %s", channelDataType));
        }
        return series;
    }

    default public TimeSeries open(Logger logger) throws ImageIOException {
        return this.open(0, logger);
    }

    public TimeSeries open(int var1, Logger var2) throws ImageIOException;

    public int numberSeries();

    public Optional<List<String>> channelNames(Logger var1) throws ImageIOException;

    public int numberChannels(Logger var1) throws ImageIOException;

    public int numberFrames(Logger var1) throws ImageIOException;

    public int bitDepth(Logger var1) throws ImageIOException;

    public ImageTimestampsAttributes timestamps() throws ImageIOException;

    public Optional<ImagePyramidMetadata> pyramid() throws ImageIOException;

    public boolean isRGB(Logger var1) throws ImageIOException;

    @Override
    public void close() throws ImageIOException;

    public Dimensions dimensionsForSeries(int var1, Logger var2) throws ImageIOException;

    default public ImageMetadata metadata(int seriesIndex, Logger logger) throws ImageIOException {
        ImageTimestampsAttributes timestamps = this.timestamps();
        return new ImageMetadata(this.dimensionsForSeries(seriesIndex, logger), this.numberChannels(logger), this.numberFrames(logger), this.numberSeries(), this.isRGB(logger), this.bitDepth(logger), timestamps.getAttributes(), timestamps.getAcqusitionTime(), this.pyramid());
    }
}

