/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.input;

import java.util.List;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.image.bean.provider.stack.Arrange;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.overlay.Overlay;
import org.anchoranalysis.image.bean.spatial.arrange.tile.Tile;
import org.anchoranalysis.image.io.bean.stack.combine.StackProviderWithLabel;
import org.anchoranalysis.image.io.bean.stack.combine.TextStyle;
import org.anchoranalysis.image.io.bean.stack.combine.WriteText;

public class TileStackProviders {
    public static StackProvider tile(List<StackProviderWithLabel> providers, int numberColumns, boolean createShort, boolean expandLabelZ) {
        Arrange arrange = new Arrange(createShort, true);
        for (StackProviderWithLabel provider : providers) {
            arrange.addStack(provider.getStack());
            arrange.addStack((Provider)TileStackProviders.addGenerateString(provider, createShort, expandLabelZ));
        }
        arrange.setArrange((StackArranger)TileStackProviders.createTile(numberColumns, providers.size()));
        return arrange;
    }

    private static Tile createTile(int numberColumns, int numberProviders) {
        Tile tile = new Tile();
        tile.setNumberColumns(numberColumns);
        tile.setNumberRows(TileStackProviders.integerDivisionRoundUp(numberProviders, numberColumns));
        tile.setCellDefault((StackArranger)new Overlay("left", "top", "repeat"));
        return tile;
    }

    private static WriteText addGenerateString(StackProviderWithLabel providerWithLabel, boolean createShort, boolean expandLabelZ) {
        WriteText out = new WriteText(providerWithLabel.getLabel());
        out.setStyle(new TextStyle());
        out.setCreateShort(createShort);
        if (expandLabelZ) {
            out.setRepeatZProvider(providerWithLabel.getStack());
        }
        return out;
    }

    private static int integerDivisionRoundUp(int dividend, int divisor) {
        return (int)Math.ceil((double)dividend / (double)divisor);
    }

    private TileStackProviders() {
    }
}

