/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.box;

import io.vavr.control.Either;
import java.util.Optional;
import java.util.stream.Stream;
import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.properties.ObjectCollectionWithProperties;
import org.anchoranalysis.image.core.object.properties.ObjectWithProperties;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.object.output.rgb.DrawObjectsGenerator;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.box.ExtractBoundingBoxAreaFromStackGenerator;
import org.anchoranalysis.image.io.stack.output.box.ScaleableBackground;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.generator.TransformingGenerator;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.spatial.box.BoundedList;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class DrawObjectOnStackGenerator
extends RasterGeneratorSelectFormat<BoundedList<ObjectMask>> {
    private final DrawObjectsGenerator drawObjectsGenerator;
    private final Optional<TransformingGenerator<BoundingBox, Stack>> backgroundGenerator;
    private final boolean flatten;

    public static DrawObjectOnStackGenerator createFromStack(ScaleableBackground background, int outlineWidth, ColorIndex colors) {
        return DrawObjectOnStackGenerator.createFromGenerator(new ExtractBoundingBoxAreaFromStackGenerator(background), outlineWidth, colors);
    }

    public static DrawObjectOnStackGenerator createWithEmptyBackground(int outlineWidth, ColorIndex colors) {
        return new DrawObjectOnStackGenerator(Optional.empty(), outlineWidth, colors, true);
    }

    public static DrawObjectOnStackGenerator createFromStack(Optional<ScaleableBackground> background, int outlineWidth, ColorIndex colors) {
        if (background.isPresent()) {
            return DrawObjectOnStackGenerator.createFromStack(background.get(), outlineWidth, colors);
        }
        return DrawObjectOnStackGenerator.createWithEmptyBackground(outlineWidth, colors);
    }

    public static DrawObjectOnStackGenerator createFromGenerator(TransformingGenerator<BoundingBox, Stack> backgroundGenerator, int outlineWidth, ColorIndex colors) {
        return new DrawObjectOnStackGenerator(Optional.of(backgroundGenerator), outlineWidth, colors, true);
    }

    public Stack transform(BoundedList<ObjectMask> element) throws OutputWriteFailedException {
        this.drawObjectsGenerator.setBackground(this.createBackground(element));
        Stream<ObjectWithProperties> objectsForDrawing = element.stream().map(object -> new ObjectWithProperties(this.prepareObjectForDrawing((ObjectMask)object, element.boundingBox())));
        return this.drawObjectsGenerator.transform(new ObjectCollectionWithProperties(objectsForDrawing));
    }

    @Override
    public StackWriteAttributes guaranteedImageAttributes() {
        return this.drawObjectsGenerator.guaranteedImageAttributes();
    }

    private DrawObjectOnStackGenerator(Optional<TransformingGenerator<BoundingBox, Stack>> backgroundGenerator, int outlineWidth, ColorIndex colorIndex, boolean flatten) {
        this.drawObjectsGenerator = DrawObjectsGenerator.outlineWithColorIndex(outlineWidth, colorIndex);
        this.backgroundGenerator = backgroundGenerator;
        this.flatten = flatten;
    }

    private ObjectMask prepareObjectForDrawing(ObjectMask object, BoundingBox containingBox) {
        if (this.flatten) {
            return this.relativeBoundingBoxToScene(object.flattenZ(), containingBox);
        }
        return this.relativeBoundingBoxToScene(object, containingBox);
    }

    private ObjectMask relativeBoundingBoxToScene(ObjectMask object, BoundingBox containingBox) {
        Point3i relativePosition = object.boundingBox().relativePositionTo(containingBox);
        return object.mapBoundingBoxPreserveExtent(boundingBox -> boundingBox.shiftTo((ReadableTuple3i)relativePosition));
    }

    private Either<Dimensions, DisplayStack> createBackground(BoundedList<ObjectMask> element) throws OutputWriteFailedException {
        if (!this.backgroundGenerator.isPresent()) {
            return Either.left((Object)new Dimensions(element.boundingBox().extent()));
        }
        Stack channelExtracted = (Stack)this.backgroundGenerator.get().transform((Object)element.boundingBox());
        if (this.flatten) {
            channelExtracted = channelExtracted.projectMax();
        }
        return Either.right((Object)new DisplayStack(channelExtracted));
    }
}

