/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.box;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.box.ScaleableBackground;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.spatial.box.BoundingBox;

public class ExtractBoundingBoxAreaFromStackGenerator
extends RasterGeneratorSelectFormat<BoundingBox> {
    private final ScaleableBackground background;

    public Stack transform(BoundingBox element) throws OutputWriteFailedException {
        try {
            return this.background.extractRegionFromStack(element);
        }
        catch (OperationFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    @Override
    public StackWriteAttributes guaranteedImageAttributes() {
        return StackWriteAttributesFactory.maybeRGBWithoutAlpha(this.background.isRGB());
    }

    public ExtractBoundingBoxAreaFromStackGenerator(ScaleableBackground background) {
        this.background = background;
    }
}

