/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.generator;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;
import org.anchoranalysis.io.generator.TransformingGenerator;
import org.anchoranalysis.io.output.bean.OutputWriteSettings;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.namestyle.IndexableOutputNameStyle;
import org.anchoranalysis.io.output.namestyle.OutputNameStyle;
import org.anchoranalysis.io.output.writer.ElementOutputter;

public abstract class RasterGenerator<T>
implements TransformingGenerator<T, Stack> {
    public void write(T element, OutputNameStyle outputNameStyle, ElementOutputter outputter) throws OutputWriteFailedException {
        this.writeInternal(element, outputNameStyle.filenameWithoutExtension(), outputNameStyle.getOutputName(), outputter);
    }

    public void writeWithIndex(T element, String index, IndexableOutputNameStyle outputNameStyle, ElementOutputter outputter) throws OutputWriteFailedException {
        this.writeInternal(element, Optional.of(outputNameStyle.filenameWithoutExtension(index)), outputNameStyle.getOutputName(), outputter);
    }

    public abstract StackWriteAttributes guaranteedImageAttributes();

    protected abstract String selectFileExtension(Stack var1, StackWriteOptions var2, OutputWriteSettings var3, Optional<Logger> var4) throws OperationFailedException;

    protected abstract void writeToFile(T var1, Stack var2, StackWriteOptions var3, OutputWriteSettings var4, Path var5) throws OutputWriteFailedException;

    private void writeInternal(T elementUntransformed, Optional<String> filenameWithoutExtension, String outputName, ElementOutputter outputter) throws OutputWriteFailedException {
        Stack transformedElement = (Stack)outputter.getExecutionTimeRecorder().recordExecutionTime(String.format("Preparing a raster to write (%s)", outputName), () -> (Stack)this.transform(elementUntransformed));
        StackWriteOptions options = new StackWriteOptions(this.writeAttributes(transformedElement), outputter.getSuggestedFormatToWrite());
        this.writeToFilesystem(elementUntransformed, transformedElement, filenameWithoutExtension, options, outputName, outputter);
    }

    private void writeToFilesystem(T elementUntransformed, Stack transformedElement, Optional<String> filenameWithoutExtension, StackWriteOptions options, String outputName, ElementOutputter outputter) throws OutputWriteFailedException {
        try {
            String extension = this.selectFileExtension(transformedElement, options, outputter.getSettings(), outputter.logger());
            Path pathToWriteTo = outputter.makeOutputPath(filenameWithoutExtension, extension, outputName);
            outputter.getExecutionTimeRecorder().recordExecutionTime(String.format("Writing raster to file-system (%s)", outputName), () -> this.writeToFile(elementUntransformed, transformedElement, options, outputter.getSettings(), pathToWriteTo));
        }
        catch (OperationFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    private StackWriteAttributes writeAttributes(Stack stack) {
        return StackWriteAttributesFactory.from(stack).or(this.guaranteedImageAttributes());
    }
}

