/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.generator;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.generator.RasterGenerator;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorDelegateToRaster;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public class RasterGeneratorBridge<T, V>
extends RasterGeneratorDelegateToRaster<V, T> {
    private final CheckedFunction<T, V, ? extends Throwable> elementBridge;

    public RasterGeneratorBridge(RasterGenerator<V> delegate, CheckedFunction<T, V, ? extends Throwable> elementBridge) {
        super(delegate);
        this.elementBridge = elementBridge;
    }

    @Override
    public Stack transform(T element) throws OutputWriteFailedException {
        try {
            return (Stack)this.getDelegate().transform(this.convertBeforeAssign(element));
        }
        catch (OperationFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    @Override
    protected V convertBeforeAssign(T element) throws OperationFailedException {
        try {
            return (V)this.elementBridge.apply(element);
        }
        catch (Exception e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected Stack convertBeforeTransform(Stack stack) {
        return stack;
    }
}

