/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.stack.output.generator;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributesFactory;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public class StackGenerator
extends RasterGeneratorSelectFormat<Stack> {
    private boolean padIfNecessary;
    private StackWriteAttributes writeOptions;

    public StackGenerator(boolean always2D) {
        this(false, always2D);
    }

    public StackGenerator(boolean padIfNecessary, boolean always2D) {
        this(padIfNecessary, StackWriteAttributesFactory.maybeAlways2D(always2D));
    }

    public Stack transform(Stack element) throws OutputWriteFailedException {
        Stack out = element.duplicateShallow();
        try {
            if (this.padIfNecessary && out.getNumberChannels() == 2) {
                out.addBlankChannel();
            }
        }
        catch (OperationFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
        return out;
    }

    @Override
    public StackWriteAttributes guaranteedImageAttributes() {
        return this.writeOptions;
    }

    public StackGenerator(boolean padIfNecessary, StackWriteAttributes writeOptions) {
        this.padIfNecessary = padIfNecessary;
        this.writeOptions = writeOptions;
    }
}

