/*-
 * #%L
 * anchor-image
 * %%
 * Copyright (C) 2010 - 2020 Owen Feehan, ETH Zurich, University of Zurich, Hoffmann-La Roche
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

package org.anchoranalysis.image.voxel.neighborhood;

import lombok.RequiredArgsConstructor;
import lombok.Value;

/**
 * Parameters used in {@code EdgeAdder} class.
 *
 * @author Owen Feehan
 */
@Value
@RequiredArgsConstructor
class EdgeAdderParameters {

    /**
     * Iff true, objects can only be neighbors if they have no intersecting voxels.
     *
     * <p>Use case: Given a partition of objects, we don't need to check if objects-intersect as
     * it's not possible by definition (a partition). However, if we have objects that can
     * potentially overlap, we define them as 'neighbors' only if objects are adjacent, but don't
     * overlap. In this case, we need to check
     */
    private final boolean preventObjectIntersection;

    /** iff true each combination of neighbors is tested only once, otherwise twice */
    private boolean testBothDirections = false;

    /** iff true uses a big-neighborhood (8 or 26 connectivity) for dilation */
    private boolean bigNeighborhood = false;
}
