/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.OperationFailedRuntimeException;
import org.anchoranalysis.image.voxel.SubrangeVoxelAccess;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.arithmetic.VoxelsArithmetic;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssignerFactory;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracterFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class BoundedVoxels<T> {
    private static final Point3i ALL_ONES_2D = new Point3i(1, 1, 0);
    private static final Point3i ALL_ONES_3D = new Point3i(1, 1, 1);
    private final BoundingBox boundingBox;
    private final Voxels<T> voxels;
    private final VoxelsExtracter<T> extracterLocal;
    private final VoxelsExtracter<T> extracterGlobal;

    public BoundedVoxels(Voxels<T> voxels) {
        this(new BoundingBox(voxels.extent()), voxels);
    }

    public BoundedVoxels(BoundedVoxels<T> source) {
        this(source.boundingBox(), source.voxels.duplicate());
    }

    public BoundedVoxels(BoundingBox boundingBox, Voxels<T> voxels) {
        Preconditions.checkArgument((boolean)boundingBox.extent().equals((Object)voxels.extent()));
        this.boundingBox = boundingBox;
        this.voxels = voxels;
        this.extracterLocal = voxels.extract();
        this.extracterGlobal = VoxelsExtracterFactory.atCorner(this.cornerMin(), voxels.extract());
    }

    public boolean equalsDeep(BoundedVoxels<?> other) {
        if (this.boundingBox.equals((Object)other.boundingBox)) {
            return this.voxels.equalsDeep(other.voxels);
        }
        return false;
    }

    public BoundedVoxels<T> replaceVoxels(Voxels<T> voxelsToAssign) {
        Preconditions.checkArgument((boolean)voxelsToAssign.extent().equals((Object)this.extent()));
        return new BoundedVoxels<T>(this.boundingBox, voxelsToAssign);
    }

    public BoundedVoxels<T> growToZ(int sizeZ, VoxelsFactoryTypeBound<T> factory) throws OperationFailedException {
        if (this.boundingBox.extent().z() != 1 && this.voxels.extent().z() != 1) {
            throw new OperationFailedException("This operation may only be used on a 2D voxels, but voxels are currently 3D.");
        }
        BoundingBox boxNew = BoundingBox.createReuse((ReadableTuple3i)this.boundingBox.cornerMin(), (Extent)this.boundingBox.extent().duplicateChangeZ(sizeZ));
        Voxels<T> buffer = factory.createInitialized(boxNew.extent());
        Extent extent = this.boundingBox.extent();
        BoundingBox boxSrc = new BoundingBox(extent);
        for (int z = 0; z < buffer.extent().z(); ++z) {
            this.extracterLocal.boxCopyTo(boxSrc, buffer, BoundingBox.createReuse((ReadableTuple3i)new Point3i(0, 0, z), (Extent)extent));
        }
        return new BoundedVoxels<T>(boxNew, buffer);
    }

    public BoundingBox dilate(boolean do3D, Optional<Extent> clipRegion) {
        Point3i allOnes = do3D ? ALL_ONES_3D : ALL_ONES_2D;
        return this.createGrownBoxAbsolute(allOnes, allOnes, clipRegion);
    }

    public BoundedVoxels<T> growBuffer(Point3i growthNegative, Point3i growthPositive, Optional<Extent> clipRegion, VoxelsFactoryTypeBound<T> factory) throws OperationFailedException {
        if (clipRegion.isPresent() && !clipRegion.get().contains(this.boundingBox)) {
            throw new OperationFailedException("Cannot grow the bounding-box of the object-mask, as it is already outside the clipping region.");
        }
        Extent extent = this.voxels.extent();
        BoundingBox grownBox = this.createGrownBoxRelative(growthNegative, growthPositive, clipRegion);
        Voxels<T> bufferNew = factory.createInitialized(grownBox.extent());
        this.extracterLocal.boxCopyTo(new BoundingBox(extent), bufferNew, BoundingBox.createReuse((ReadableTuple3i)grownBox.cornerMin(), (Extent)extent));
        BoundingBox box = BoundingBox.createReuse((ReadableTuple3i)Point3i.immutableSubtract((ReadableTuple3i)this.boundingBox.cornerMin(), (ReadableTuple3i)grownBox.cornerMin()), (Extent)grownBox.extent());
        return new BoundedVoxels<T>(box, bufferNew);
    }

    public BoundedVoxels<T> scale(ScaleFactor scaleFactor, VoxelsResizer resizer, Optional<Extent> clipTo) {
        BoundingBox boundingBoxScaled = clipTo.map(extent -> this.boundingBox.scaleClampTo(scaleFactor, extent)).orElseGet(() -> this.boundingBox.scale(scaleFactor));
        Voxels<T> voxelsOut = this.extracterLocal.resizedXY(boundingBoxScaled.extent().x(), boundingBoxScaled.extent().y(), resizer);
        return new BoundedVoxels<T>(boundingBoxScaled, voxelsOut);
    }

    public BoundedVoxels<T> projectMax() {
        return new BoundedVoxels<T>(this.boundingBox.flattenZ(), this.extracterLocal.projectMax());
    }

    public BoundedVoxels<T> duplicate() {
        return new BoundedVoxels<T>(this);
    }

    public T sliceBufferLocal(int sliceIndexRelative) {
        return this.voxels.sliceBuffer(sliceIndexRelative);
    }

    public T sliceBufferGlobal(int sliceIndexGlobal) {
        return this.voxels.sliceBuffer(sliceIndexGlobal - this.boundingBox().cornerMin().z());
    }

    public Extent extent() {
        return this.voxels.extent();
    }

    public BoundedVoxels<T> regionZ(int zMin, int zMax, VoxelsFactoryTypeBound<T> factory) throws CreateException {
        if (!this.boundingBox.contains().z(zMin)) {
            throw new CreateException("zMin outside range");
        }
        if (!this.boundingBox.contains().z(zMax)) {
            throw new CreateException("zMax outside range");
        }
        int relZ = zMin - this.boundingBox.cornerMin().z();
        BoundingBox target = BoundingBox.createReuse((ReadableTuple3i)this.boundingBox.cornerMin().duplicateChangeZ(zMin), (Extent)this.boundingBox.extent().duplicateChangeZ(zMax - zMin + 1));
        SubrangeVoxelAccess voxelAccess = new SubrangeVoxelAccess(relZ, target.extent(), this);
        return new BoundedVoxels<T>(target, factory.create(voxelAccess));
    }

    public BoundedVoxels<T> region(BoundingBox box, boolean reuseIfPossible) throws CreateException {
        if (!this.boundingBox.contains().box(box)) {
            throw new CreateException("The source box does not contain the target box");
        }
        return new BoundedVoxels<T>(box, this.extracterGlobal.region(box, reuseIfPossible));
    }

    public BoundedVoxels<T> regionIntersecting(BoundingBox box, int voxelValueForRest) throws CreateException {
        Optional boxIntersect = this.boundingBox.intersection().with(box);
        if (!boxIntersect.isPresent()) {
            throw new CreateException("Requested bounding-box does not intersect with current bounds");
        }
        Voxels<T> bufferNew = this.voxels.factory().createInitialized(box.extent());
        if (voxelValueForRest != 0) {
            this.voxels.assignValue(voxelValueForRest).toAll();
        }
        this.extracterGlobal.boxCopyTo((BoundingBox)boxIntersect.get(), bufferNew, ((BoundingBox)boxIntersect.get()).relativePositionToBox(box));
        return new BoundedVoxels<T>(box, bufferNew);
    }

    public BoundedVoxels<T> mapBoundingBoxPreserveExtent(BoundingBox boundingBoxToAssign) {
        if (!boundingBoxToAssign.extent().equals((Object)this.boundingBox.extent())) {
            throw new OperationFailedRuntimeException("The extent changed while mapping bounding-box, which is not allowed.");
        }
        return new BoundedVoxels<T>(boundingBoxToAssign, this.voxels);
    }

    public BoundedVoxels<T> extractSlice(int sliceIndex) {
        int zRelative = sliceIndex - this.boundingBox().cornerMin().z();
        BoundingBox boxFlattened = this.boundingBox.flattenZ();
        Voxels<T> slice = this.extracterLocal.slice(zRelative);
        return new BoundedVoxels<T>(boxFlattened, slice);
    }

    public ReadableTuple3i cornerMin() {
        return this.boundingBox.cornerMin();
    }

    public void replaceSlice(int sliceIndexToUpdate, VoxelBuffer<T> bufferToAssign) {
        this.voxels.replaceSlice(sliceIndexToUpdate, bufferToAssign);
    }

    public VoxelsArithmetic arithmetic() {
        return this.voxels.arithmetic();
    }

    public String toString() {
        return this.boundingBox.toString();
    }

    public VoxelsAssigner assignValue(int valueToAssign) {
        return VoxelsAssignerFactory.shiftBackBy(this.voxels.assignValue(valueToAssign), this.boundingBox.cornerMin());
    }

    public final VoxelsExtracter<T> extract() {
        return this.extracterGlobal;
    }

    private BoundingBox createGrownBoxAbsolute(Point3i negative, Point3i positive, Optional<Extent> clipRegion) {
        BoundingBox relBox = this.createGrownBoxRelative(negative, positive, clipRegion);
        return relBox.reflectThroughOrigin().shiftBy(this.boundingBox.cornerMin());
    }

    private BoundingBox createGrownBoxRelative(Point3i negative, Point3i positive, Optional<Extent> clipRegion) {
        Point3i negClamped = new Point3i(BoundedVoxels.clampNegative(this.boundingBox.cornerMin().x(), negative.x()), BoundedVoxels.clampNegative(this.boundingBox.cornerMin().y(), negative.y()), BoundedVoxels.clampNegative(this.boundingBox.cornerMin().z(), negative.z()));
        ReadableTuple3i boxMax = this.boundingBox.calculateCornerMaxInclusive();
        Object maxPossible = clipRegion.isPresent() ? clipRegion.get().asTuple() : new Point3i(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        Point3i growBy = new Point3i(BoundedVoxels.clampPositive(boxMax.x(), positive.x(), maxPossible.x()) + negClamped.x(), BoundedVoxels.clampPositive(boxMax.y(), positive.y(), maxPossible.y()) + negClamped.y(), BoundedVoxels.clampPositive(boxMax.z(), positive.z(), maxPossible.z()) + negClamped.z());
        return BoundingBox.createReuse((ReadableTuple3i)negClamped, (Extent)this.voxels.extent().growBy((ReadableTuple3i)growBy));
    }

    private static int clampNegative(int corner, int negativeIncrement) {
        int diff = corner - negativeIncrement;
        if (diff > 0) {
            return negativeIncrement;
        }
        return negativeIncrement + diff;
    }

    private static int clampPositive(int corner, int positiveIncrement, int max) {
        int sum = corner + positiveIncrement;
        if (sum < max) {
            return positiveIncrement;
        }
        return positiveIncrement - (sum - max + 1);
    }

    public BoundingBox boundingBox() {
        return this.boundingBox;
    }

    public Voxels<T> voxels() {
        return this.voxels;
    }
}

