/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel;

import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.spatial.box.Extent;

class SubrangeVoxelAccess<T>
implements SliceBufferIndex<T> {
    private int zRelative;
    private Extent extent;
    private BoundedVoxels<T> voxels;

    @Override
    public void replaceSlice(int sliceIndex, VoxelBuffer<T> sliceToAssign) {
        this.voxels.replaceSlice(sliceIndex + this.zRelative, sliceToAssign);
    }

    @Override
    public VoxelBuffer<T> slice(int sliceIndex) {
        return this.voxels.voxels().slice(sliceIndex + this.zRelative);
    }

    @Override
    public Extent extent() {
        return this.extent;
    }

    public SubrangeVoxelAccess(int zRelative, Extent extent, BoundedVoxels<T> voxels) {
        this.zRelative = zRelative;
        this.extent = extent;
        this.voxels = voxels;
    }
}

