/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.anchoranalysis.image.voxel.arithmetic.VoxelsArithmetic;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public abstract class Voxels<T> {
    public static final Extent MAX_IN_TO_STRING = new Extent(100, 100, 5);
    private final SliceBufferIndex<T> slices;
    private final VoxelsFactoryTypeBound<T> factory;
    private final VoxelsArithmetic arithmetic;

    public abstract VoxelsExtracter<T> extract();

    public abstract VoxelsAssigner assignValue(int var1);

    public VoxelDataType dataType() {
        return this.factory.dataType();
    }

    public VoxelBuffer<T> slice(int z) {
        return this.slices.slice(z);
    }

    public T sliceBuffer(int z) {
        return this.slice(z).buffer();
    }

    public Extent extent() {
        return this.slices.extent();
    }

    public Voxels<T> duplicate() {
        Voxels<T> out = this.factory.createInitialized(this.slices().extent());
        this.extent().iterateOverZ(z -> out.replaceSlice(z, this.slice(z).duplicate()));
        return out;
    }

    public boolean equalsDeep(Voxels<?> other) {
        if (!this.factory.dataType().equals(other.factory().dataType())) {
            return false;
        }
        if (!this.extent().equals((Object)other.extent())) {
            return false;
        }
        return this.extent().iterateOverZUntil(z -> this.sliceBuffer(z).equals(other.sliceBuffer(z)));
    }

    public void replaceSlice(int sliceIndexToUpdate, VoxelBuffer<T> bufferToAssign) {
        this.slices().replaceSlice(sliceIndexToUpdate, bufferToAssign);
    }

    public String toString() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (PrintStream stream = new PrintStream(output);){
            stream.printf("The voxels have dimensionality: %s%n", this.extent());
            Extent bounds = this.extent().minimum(MAX_IN_TO_STRING);
            bounds.iterateOverZ(sliceIndex -> this.printSlice(stream, sliceIndex, bounds));
        }
        return output.toString();
    }

    private void printSlice(PrintStream stream, int sliceIndex, Extent bounds) {
        stream.printf("Showing slice %d, the first %d rows and %d columns:%n", sliceIndex, bounds.y(), bounds.x());
        Point3i point = new Point3i(0, 0, sliceIndex);
        point.setY(0);
        while (point.y() < bounds.y()) {
            point.setX(0);
            while (point.x() < bounds.x()) {
                stream.printf("%03d ", this.extract().voxel((ReadableTuple3i)point));
                point.incrementX();
            }
            stream.println();
            point.incrementY();
        }
    }

    public Voxels(SliceBufferIndex<T> slices, VoxelsFactoryTypeBound<T> factory, VoxelsArithmetic arithmetic) {
        this.slices = slices;
        this.factory = factory;
        this.arithmetic = arithmetic;
    }

    public SliceBufferIndex<T> slices() {
        return this.slices;
    }

    public VoxelsFactoryTypeBound<T> factory() {
        return this.factory;
    }

    public VoxelsArithmetic arithmetic() {
        return this.arithmetic;
    }
}

