/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.util.function.IntFunction;
import org.anchoranalysis.image.voxel.arithmetic.VoxelsArithmetic;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

abstract class Base<T>
implements VoxelsArithmetic {
    private final Extent extent;
    private final IntFunction<T> bufferForSlice;

    @Override
    public void multiplyBy(double factor) {
        if (factor != 1.0) {
            this.extent.iterateOverZ(z -> this.multiplyBuffer(this.bufferForSlice.apply(z), factor));
        }
    }

    @Override
    public void divideBy(int divisor) {
        if (divisor != 1) {
            this.extent.iterateOverZ(z -> this.divideByBuffer(this.bufferForSlice.apply(z), divisor));
        }
    }

    @Override
    public void subtractFrom(int valueToSubtractFrom) {
        for (int z = 0; z < this.extent.z(); ++z) {
            this.subtractFromBuffer(this.bufferForSlice.apply(z), valueToSubtractFrom);
        }
    }

    @Override
    public void addTo(ObjectMask object, int valueToBeAdded) {
        BoundingBox box = object.boundingBox();
        byte maskOnByte = object.binaryValuesByte().getOn();
        ReadableTuple3i pointMax = box.calculateCornerMaxExclusive();
        for (int z = box.cornerMin().z(); z < pointMax.z(); ++z) {
            T pixels = this.bufferForSlice.apply(z);
            UnsignedByteBuffer pixelsMask = object.sliceBufferGlobal(z);
            for (int y = box.cornerMin().y(); y < pointMax.y(); ++y) {
                for (int x = box.cornerMin().x(); x < pointMax.x(); ++x) {
                    if (pixelsMask.getRaw() != maskOnByte) continue;
                    this.addToBufferIndex(pixels, this.extent.offset(x, y), valueToBeAdded);
                }
            }
        }
    }

    @Override
    public void multiplyBy(ObjectMask object, double factor) {
        BoundingBox box = object.boundingBox();
        byte maskOnByte = object.binaryValuesByte().getOn();
        ReadableTuple3i pointMax = box.calculateCornerMaxInclusive();
        for (int z = box.cornerMin().z(); z <= pointMax.z(); ++z) {
            T pixels = this.bufferForSlice.apply(z);
            UnsignedByteBuffer pixelsMask = object.sliceBufferGlobal(z);
            for (int y = box.cornerMin().y(); y <= pointMax.y(); ++y) {
                for (int x = box.cornerMin().x(); x <= pointMax.x(); ++x) {
                    if (pixelsMask.getRaw() != maskOnByte) continue;
                    int index = this.extent.offset(x, y);
                    this.multiplyByBufferIndex(pixels, index, factor);
                }
            }
        }
    }

    protected abstract void subtractFromBuffer(T var1, int var2);

    protected abstract void multiplyBuffer(T var1, double var2);

    protected abstract void divideByBuffer(T var1, int var2);

    protected abstract void multiplyByBufferIndex(T var1, int var2, double var3);

    protected abstract void addToBufferIndex(T var1, int var2, int var3);

    protected Base(Extent extent, IntFunction<T> bufferForSlice) {
        this.extent = extent;
        this.bufferForSlice = bufferForSlice;
    }
}

