/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.util.function.IntUnaryOperator;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedBufferAsInt;

class UnsignedBufferAsIntHelper {
    public static void calculateForIndex(UnsignedBufferAsInt buffer, int maximumValue, int index, IntUnaryOperator operator) {
        UnsignedBufferAsIntHelper.putClampedAtIndex(buffer, maximumValue, operator.applyAsInt(buffer.getUnsigned(index)), index);
    }

    public static void calculateForEveryVoxel(UnsignedBufferAsInt buffer, int maximumValue, IntUnaryOperator operator) {
        while (buffer.hasRemaining()) {
            int valueToAssign = operator.applyAsInt(buffer.getUnsigned());
            UnsignedBufferAsIntHelper.putClamped(buffer, maximumValue, valueToAssign);
        }
    }

    private static void putClamped(UnsignedBufferAsInt buffer, int maximumValue, int valueToAssign) {
        UnsignedBufferAsIntHelper.putClampedAtIndex(buffer, maximumValue, valueToAssign, buffer.position() - 1);
    }

    private static void putClampedAtIndex(UnsignedBufferAsInt buffer, int maximumValue, int valueToAssign, int index) {
        buffer.putUnsigned(index, UnsignedBufferAsIntHelper.clamp(valueToAssign, maximumValue));
    }

    private static int clamp(int value, int maximumValue) {
        if (value < 0) {
            return 0;
        }
        if (value > maximumValue) {
            return maximumValue;
        }
        return value;
    }

    private UnsignedBufferAsIntHelper() {
    }
}

