/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.util.function.IntFunction;
import org.anchoranalysis.image.voxel.arithmetic.Base;
import org.anchoranalysis.image.voxel.arithmetic.BinaryOperationHelper;
import org.anchoranalysis.image.voxel.arithmetic.UnsignedBufferAsIntHelper;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedByteImplementation
extends Base<UnsignedByteBuffer> {
    private static final int MAXIMUM_VALUE = 255;

    public UnsignedByteImplementation(Extent extent, IntFunction<UnsignedByteBuffer> bufferForSlice) {
        super(extent, bufferForSlice);
    }

    @Override
    protected void multiplyBuffer(UnsignedByteBuffer buffer, double factor) {
        UnsignedBufferAsIntHelper.calculateForEveryVoxel(buffer, 255, value -> BinaryOperationHelper.multiplyByInt(value, factor));
    }

    @Override
    protected void divideByBuffer(UnsignedByteBuffer buffer, int divisor) {
        UnsignedBufferAsIntHelper.calculateForEveryVoxel(buffer, 255, value -> value / divisor);
    }

    @Override
    protected void subtractFromBuffer(UnsignedByteBuffer buffer, int valueToSubtractFrom) {
        UnsignedBufferAsIntHelper.calculateForEveryVoxel(buffer, 255, value -> valueToSubtractFrom - value);
    }

    @Override
    protected void multiplyByBufferIndex(UnsignedByteBuffer buffer, int index, double factor) {
        UnsignedBufferAsIntHelper.calculateForIndex(buffer, index, 255, value -> BinaryOperationHelper.multiplyByInt(value, factor));
    }

    @Override
    protected void addToBufferIndex(UnsignedByteBuffer buffer, int index, int valueToBeAdded) {
        UnsignedBufferAsIntHelper.calculateForIndex(buffer, index, 255, value -> value + valueToBeAdded);
    }
}

