/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.util.function.LongUnaryOperator;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;

class UnsignedIntHelper {
    private static final long MAXIMUM_VALUE = 0xFFFFFFFFL;

    public static void calculateForEveryVoxel(UnsignedIntBuffer buffer, LongUnaryOperator operator) {
        while (buffer.hasRemaining()) {
            UnsignedIntHelper.putClamped(buffer, operator.applyAsLong(buffer.getUnsigned()));
        }
    }

    public static void calculateForIndex(UnsignedIntBuffer buffer, int index, LongUnaryOperator operator) {
        UnsignedIntHelper.putClampedAtIndex(buffer, operator.applyAsLong(buffer.getUnsigned(index)), index);
    }

    private static void putClamped(UnsignedIntBuffer buffer, long valueToAssign) {
        UnsignedIntHelper.putClampedAtIndex(buffer, valueToAssign, buffer.position() - 1);
    }

    private static void putClampedAtIndex(UnsignedIntBuffer buffer, long valueToAssign, int index) {
        buffer.putUnsigned(index, UnsignedIntHelper.clamp(valueToAssign));
    }

    private static long clamp(long value) {
        if (value < 0L) {
            return 0L;
        }
        if (value > 0xFFFFFFFFL) {
            return 0xFFFFFFFFL;
        }
        return value;
    }

    private UnsignedIntHelper() {
    }
}

