/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.util.function.IntFunction;
import org.anchoranalysis.image.voxel.arithmetic.Base;
import org.anchoranalysis.image.voxel.arithmetic.BinaryOperationHelper;
import org.anchoranalysis.image.voxel.arithmetic.UnsignedBufferAsIntHelper;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedShortImplementation
extends Base<UnsignedShortBuffer> {
    private static final int MAXIMUM_VALUE = 65535;

    public UnsignedShortImplementation(Extent extent, IntFunction<UnsignedShortBuffer> bufferForSlice) {
        super(extent, bufferForSlice);
    }

    @Override
    protected void multiplyBuffer(UnsignedShortBuffer buffer, double factor) {
        UnsignedBufferAsIntHelper.calculateForEveryVoxel(buffer, 65535, value -> BinaryOperationHelper.multiplyByInt(value, factor));
    }

    @Override
    protected void divideByBuffer(UnsignedShortBuffer buffer, int divisor) {
        UnsignedBufferAsIntHelper.calculateForEveryVoxel(buffer, 65535, value -> value / divisor);
    }

    @Override
    protected void multiplyByBufferIndex(UnsignedShortBuffer buffer, int index, double factor) {
        UnsignedBufferAsIntHelper.calculateForIndex(buffer, 65535, index, value -> BinaryOperationHelper.multiplyByInt(value, factor));
    }

    @Override
    protected void subtractFromBuffer(UnsignedShortBuffer buffer, int valueToSubtractFrom) {
        UnsignedBufferAsIntHelper.calculateForEveryVoxel(buffer, 65535, value -> valueToSubtractFrom - value);
    }

    @Override
    protected void addToBufferIndex(UnsignedShortBuffer buffer, int index, int valueToBeAdded) {
        UnsignedBufferAsIntHelper.calculateForIndex(buffer, 65535, index, value -> value + valueToBeAdded);
    }
}

