/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.arithmetic;

import java.nio.FloatBuffer;
import java.util.function.IntFunction;
import org.anchoranalysis.image.voxel.arithmetic.FloatImplementation;
import org.anchoranalysis.image.voxel.arithmetic.UnsignedByteImplementation;
import org.anchoranalysis.image.voxel.arithmetic.UnsignedIntImplementation;
import org.anchoranalysis.image.voxel.arithmetic.UnsignedShortImplementation;
import org.anchoranalysis.image.voxel.arithmetic.VoxelsArithmetic;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.spatial.box.Extent;

public class VoxelsArithmeticFactory {
    public static VoxelsArithmetic createUnsignedByte(Extent extent, IntFunction<UnsignedByteBuffer> bufferForSlice) {
        return new UnsignedByteImplementation(extent, bufferForSlice);
    }

    public static VoxelsArithmetic createUnsignedShort(Extent extent, IntFunction<UnsignedShortBuffer> bufferForSlice) {
        return new UnsignedShortImplementation(extent, bufferForSlice);
    }

    public static VoxelsArithmetic createUnsignedInt(Extent extent, IntFunction<UnsignedIntBuffer> bufferForSlice) {
        return new UnsignedIntImplementation(extent, bufferForSlice);
    }

    public static VoxelsArithmetic createFloat(Extent extent, IntFunction<FloatBuffer> bufferForSlice) {
        return new FloatImplementation(extent, bufferForSlice);
    }

    private VoxelsArithmeticFactory() {
    }
}

