/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.assigner;

import java.util.function.IntPredicate;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class ShiftBackwardsBy
implements VoxelsAssigner {
    private final VoxelsAssigner voxelsAssigner;
    private final ReadableTuple3i shift;

    @Override
    public void toVoxel(int x, int y, int z) {
        this.voxelsAssigner.toVoxel(x - this.shift.x(), y - this.shift.y(), z - this.shift.z());
    }

    @Override
    public void toBox(BoundingBox box) {
        this.voxelsAssigner.toBox(this.shift(box));
    }

    @Override
    public void toAll() {
        this.voxelsAssigner.toAll();
    }

    @Override
    public void toObject(ObjectMask object) {
        this.voxelsAssigner.toObject(this.shift(object));
    }

    @Override
    public void toObjectIf(ObjectMask object, IntPredicate voxelPredicate) {
        this.voxelsAssigner.toObjectIf(this.shift(object), voxelPredicate);
    }

    @Override
    public boolean toObjectWhile(ObjectMask object, IntPredicate voxelPredicate) {
        return this.voxelsAssigner.toObjectWhile(this.shift(object), voxelPredicate);
    }

    @Override
    public void toObject(ObjectMask object, BoundingBox restrictTo) {
        this.voxelsAssigner.toObject(this.shift(object), this.shift(restrictTo));
    }

    @Override
    public void toEitherTwoObjects(ObjectMask object1, ObjectMask object2, BoundingBox restrictTo) {
        this.voxelsAssigner.toEitherTwoObjects(this.shift(object1), this.shift(object2), this.shift(restrictTo));
    }

    private BoundingBox shift(BoundingBox box) {
        return box.shiftBackBy(this.shift);
    }

    private ObjectMask shift(ObjectMask object) {
        return object.shiftBackBy(this.shift);
    }

    public ShiftBackwardsBy(VoxelsAssigner voxelsAssigner, ReadableTuple3i shift) {
        this.voxelsAssigner = voxelsAssigner;
        this.shift = shift;
    }
}

