/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.assigner;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.assigner.FloatImplementation;
import org.anchoranalysis.image.voxel.assigner.ShiftBackwardsBy;
import org.anchoranalysis.image.voxel.assigner.UnsignedByteImplementation;
import org.anchoranalysis.image.voxel.assigner.UnsignedIntImplementation;
import org.anchoranalysis.image.voxel.assigner.UnsignedShortImplementation;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class VoxelsAssignerFactory {
    public static VoxelsAssigner createUnsignedByte(Voxels<UnsignedByteBuffer> voxels, int valueToAssign) {
        return new UnsignedByteImplementation(voxels, valueToAssign);
    }

    public static VoxelsAssigner createUnsignedShort(Voxels<UnsignedShortBuffer> voxels, int valueToAssign) {
        return new UnsignedShortImplementation(voxels, valueToAssign);
    }

    public static VoxelsAssigner createUnsignedInt(Voxels<UnsignedIntBuffer> voxels, int valueToAssign) {
        return new UnsignedIntImplementation(voxels, valueToAssign);
    }

    public static VoxelsAssigner createFloat(Voxels<FloatBuffer> voxels, int valueToAssign) {
        return new FloatImplementation(voxels, valueToAssign);
    }

    public static VoxelsAssigner shiftBackBy(VoxelsAssigner voxelsAssigner, ReadableTuple3i shift) {
        return new ShiftBackwardsBy(voxelsAssigner, shift);
    }

    private VoxelsAssignerFactory() {
    }
}

