/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary;

import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsByte;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsInt;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.spatial.box.Extent;

public class BinaryVoxelsFactory {
    public static BinaryVoxels<UnsignedByteBuffer> createEmptyOn(Extent extent) {
        BinaryVoxels<UnsignedByteBuffer> voxels = BinaryVoxelsFactory.createEmptyOff(extent);
        voxels.assignOn().toAll();
        return voxels;
    }

    public static BinaryVoxels<UnsignedByteBuffer> createEmptyOff(Extent extent) {
        try {
            return BinaryVoxelsFactory.createEmptyOff(extent, UnsignedByteVoxelType.INSTANCE);
        }
        catch (CreateException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    public static BinaryVoxels<?> createEmptyOff(Extent extent, VoxelDataType dataType) throws CreateException {
        if (dataType.equals(UnsignedByteVoxelType.INSTANCE)) {
            return new BinaryVoxelsByte(VoxelsFactory.getUnsignedByte().createInitialized(extent), BinaryValuesInt.getDefault());
        }
        if (dataType.equals(UnsignedIntVoxelType.INSTANCE)) {
            return new BinaryVoxelsInt(VoxelsFactory.getUnsignedInt().createInitialized(extent), BinaryValuesInt.getDefault());
        }
        throw new CreateException("Unsupported voxel-data-type, only unsigned byte and int are supported");
    }

    public static BinaryVoxels<UnsignedByteBuffer> reuseByte(Voxels<UnsignedByteBuffer> voxels) {
        return BinaryVoxelsFactory.reuseByte(voxels, BinaryValuesInt.getDefault());
    }

    public static BinaryVoxels<UnsignedByteBuffer> reuseByte(Voxels<UnsignedByteBuffer> voxels, BinaryValuesInt binaryValues) {
        return new BinaryVoxelsByte(voxels, binaryValues);
    }

    public static BinaryVoxels<UnsignedIntBuffer> reuseInt(Voxels<UnsignedIntBuffer> voxels, BinaryValuesInt binaryValues) {
        return new BinaryVoxelsInt(voxels, binaryValues);
    }

    private BinaryVoxelsFactory() {
    }
}

