/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.spatial.box.Extent;

public final class SlidingBuffer<T> {
    private final Voxels<T> voxels;
    private VoxelBuffer<T> center;
    private VoxelBuffer<T> plusOne;
    private VoxelBuffer<T> minusOne;
    private int sliceIndex = -1;

    public SlidingBuffer(Voxels<T> voxels) {
        this.voxels = voxels;
        this.seek(0);
    }

    public void seek(int sliceIndexToSeek) {
        if (sliceIndexToSeek == this.sliceIndex) {
            return;
        }
        this.sliceIndex = sliceIndexToSeek;
        this.minusOne = null;
        this.center = this.voxels.slice(this.sliceIndex);
        if (this.sliceIndex - 1 >= 0) {
            this.minusOne = this.voxels.slice(this.sliceIndex - 1);
        }
        if (this.sliceIndex + 1 < this.voxels.extent().z()) {
            this.plusOne = this.voxels.slice(this.sliceIndex + 1);
        }
    }

    public void shift() {
        this.minusOne = this.center;
        this.center = this.plusOne;
        ++this.sliceIndex;
        this.plusOne = this.sliceIndex + 1 < this.voxels.extent().z() ? this.voxels.slice(this.sliceIndex + 1) : null;
    }

    public VoxelBuffer<T> bufferRelative(int relativeIndex) {
        switch (relativeIndex) {
            case 1: {
                return this.plusOne;
            }
            case 0: {
                return this.center;
            }
            case -1: {
                return this.minusOne;
            }
        }
        return this.voxels.slice(this.sliceIndex + relativeIndex);
    }

    public Extent extent() {
        return this.voxels.extent();
    }

    public Voxels<T> getVoxels() {
        return this.voxels;
    }

    public VoxelBuffer<T> getCenter() {
        return this.center;
    }

    public VoxelBuffer<T> getPlusOne() {
        return this.plusOne;
    }

    public VoxelBuffer<T> getMinusOne() {
        return this.minusOne;
    }
}

