/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.primitive;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedBufferAsInt;

public final class UnsignedByteBuffer
extends UnsignedBufferAsInt {
    private final ByteBuffer delegate;

    public static UnsignedByteBuffer allocate(int capacity) {
        return new UnsignedByteBuffer(ByteBuffer.allocate(capacity));
    }

    public static UnsignedByteBuffer wrapRaw(byte[] array) {
        return new UnsignedByteBuffer(ByteBuffer.wrap(array));
    }

    public static UnsignedByteBuffer wrapRaw(ByteBuffer bufferRaw) {
        return new UnsignedByteBuffer(bufferRaw);
    }

    private UnsignedByteBuffer(ByteBuffer delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public byte getRaw() {
        return this.delegate.get();
    }

    public byte getRaw(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int getUnsigned() {
        return PrimitiveConverter.unsignedByteToInt(this.getRaw());
    }

    @Override
    public int getUnsigned(int index) {
        return PrimitiveConverter.unsignedByteToInt(this.getRaw(index));
    }

    public void putRaw(byte value) {
        this.delegate.put(value);
    }

    public void putRaw(int index, byte value) {
        this.delegate.put(index, value);
    }

    @Override
    public void putUnsigned(int value) {
        this.putRaw((byte)value);
    }

    @Override
    public void putUnsigned(int index, int value) {
        this.putRaw(index, (byte)value);
    }

    public void putUnsignedInt(int value) {
        this.putRaw((byte)PrimitiveConverter.unsignedIntToLong(value));
    }

    @Override
    public void putLong(long value) {
        this.putRaw((byte)value);
    }

    @Override
    public void putFloat(float value) {
        this.putRaw((byte)value);
    }

    @Override
    public void putFloat(int index, float value) {
        this.putRaw(index, (byte)value);
    }

    public void putFloatClamped(float value) {
        if (value > 255.0f) {
            value = 255.0f;
        }
        if (value < 0.0f) {
            value = 0.0f;
        }
        this.putFloat(value);
    }

    @Override
    public void putDouble(double value) {
        this.putRaw((byte)value);
    }

    public void putDoubleClamped(double value) {
        if (value > 255.0) {
            value = 255.0;
        }
        if (value < 0.0) {
            value = 0.0;
        }
        this.putDouble(value);
    }

    @Override
    public void putDouble(int index, double value) {
        this.putRaw(index, (byte)value);
    }

    public void put(ByteBuffer source) {
        this.delegate.put(source);
    }

    public void put(UnsignedByteBuffer source) {
        this.delegate.put(source.getDelegate());
    }

    public final byte[] array() {
        Preconditions.checkArgument((boolean)this.delegate.hasArray());
        return this.delegate.array();
    }

    public final void rewind() {
        this.delegate.rewind();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnsignedByteBuffer)) {
            return false;
        }
        UnsignedByteBuffer other = (UnsignedByteBuffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnsignedByteBuffer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public ByteBuffer getDelegate() {
        return this.delegate;
    }
}

