/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.primitive;

import com.google.common.base.Preconditions;
import java.nio.ShortBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedBufferAsInt;

public final class UnsignedShortBuffer
extends UnsignedBufferAsInt {
    private final ShortBuffer delegate;

    public static UnsignedShortBuffer allocate(int capacity) {
        return new UnsignedShortBuffer(ShortBuffer.allocate(capacity));
    }

    public static UnsignedShortBuffer wrapRaw(short[] array) {
        return new UnsignedShortBuffer(ShortBuffer.wrap(array));
    }

    public static UnsignedShortBuffer wrapRaw(ShortBuffer bufferRaw) {
        return new UnsignedShortBuffer(bufferRaw);
    }

    private UnsignedShortBuffer(ShortBuffer delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public short getRaw() {
        return this.delegate.get();
    }

    public short getRaw(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int getUnsigned() {
        return PrimitiveConverter.unsignedShortToInt(this.getRaw());
    }

    @Override
    public int getUnsigned(int index) {
        return PrimitiveConverter.unsignedShortToInt(this.getRaw(index));
    }

    public void putRaw(short value) {
        this.delegate.put(value);
    }

    public void putRaw(int index, short value) {
        this.delegate.put(index, value);
    }

    @Override
    public void putUnsigned(int value) {
        this.putRaw((short)value);
    }

    public void putUnsignedClamped(int value) {
        if (value > 65535) {
            this.putUnsigned(65535);
        } else if (value < 0) {
            this.putUnsigned(0);
        } else {
            this.putUnsigned(value);
        }
    }

    @Override
    public void putUnsigned(int index, int value) {
        this.putRaw(index, (short)value);
    }

    @Override
    public void putLong(long value) {
        this.putRaw((short)value);
    }

    public void putLongClamped(long value) {
        if (value > 65535L) {
            this.putUnsigned(65535);
        } else if (value < 0L) {
            this.putUnsigned(0);
        } else {
            this.putLong(value);
        }
    }

    @Override
    public void putFloat(float value) {
        this.putRaw((short)value);
    }

    public void putFloatClamped(float value) {
        if (value > 65535.0f) {
            this.putUnsigned(65535);
        } else if (value < 0.0f) {
            this.putUnsigned(0);
        } else {
            this.putFloat(value);
        }
    }

    @Override
    public void putFloat(int index, float value) {
        this.putRaw(index, (short)value);
    }

    @Override
    public void putDouble(double value) {
        this.putRaw((short)value);
    }

    @Override
    public void putDouble(int index, double value) {
        this.putRaw(index, (short)value);
    }

    public void put(ShortBuffer source) {
        this.delegate.put(source);
    }

    public void put(UnsignedShortBuffer source) {
        this.delegate.put(source.getDelegate());
    }

    public final short[] array() {
        Preconditions.checkArgument((boolean)this.delegate.hasArray());
        return this.delegate.array();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnsignedShortBuffer)) {
            return false;
        }
        UnsignedShortBuffer other = (UnsignedShortBuffer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UnsignedShortBuffer;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public ShortBuffer getDelegate() {
        return this.delegate;
    }
}

