/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.slice;

import com.google.common.base.Preconditions;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferFactory;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.spatial.box.Extent;

public class FromByte
implements SliceBufferIndex<UnsignedByteBuffer> {
    private final VoxelBuffer<UnsignedByteBuffer>[] buffer;
    private final Extent extent;

    public static SliceBufferIndex<UnsignedByteBuffer> createInitialized(Extent extent) {
        FromByte p = new FromByte(extent);
        p.initialize();
        return p;
    }

    public static SliceBufferIndex<UnsignedByteBuffer> createUninitialized(Extent extent) {
        return new FromByte(extent);
    }

    private FromByte(Extent extent) {
        this.extent = extent;
        this.buffer = VoxelBufferFactory.allocateUnsignedByteArray(extent.z());
    }

    @Override
    public void replaceSlice(int z, VoxelBuffer<UnsignedByteBuffer> sliceToAssign) {
        this.buffer[z] = sliceToAssign;
        this.buffer[z].buffer().clear();
    }

    @Override
    public VoxelBuffer<UnsignedByteBuffer> slice(int z) {
        Preconditions.checkArgument((z >= 0 ? 1 : 0) != 0);
        VoxelBuffer<UnsignedByteBuffer> bufferSlice = this.buffer[z];
        bufferSlice.buffer().clear();
        return bufferSlice;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }

    private void initialize() {
        int volumeXY = this.extent.areaXY();
        this.extent.iterateOverZ(z -> {
            this.buffer[z] = VoxelBufferFactory.allocateUnsignedByte(volumeXY);
        });
    }
}

