/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.slice;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferFactory;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.spatial.box.Extent;

public class FromFloat
implements SliceBufferIndex<FloatBuffer> {
    private final VoxelBuffer<FloatBuffer>[] buffer;
    private final Extent extent;

    public static SliceBufferIndex<FloatBuffer> createInitialized(Extent extent) {
        FromFloat p = new FromFloat(extent);
        p.initialize();
        return p;
    }

    public static SliceBufferIndex<FloatBuffer> createUninitialized(Extent extent) {
        return new FromFloat(extent);
    }

    private FromFloat(Extent extent) {
        this.extent = extent;
        this.buffer = VoxelBufferFactory.allocateFloatArray(extent.z());
    }

    private void initialize() {
        int volumeXY = this.extent.areaXY();
        for (int z = 0; z < this.extent.z(); ++z) {
            this.buffer[z] = VoxelBufferFactory.allocateFloat(volumeXY);
        }
    }

    @Override
    public void replaceSlice(int z, VoxelBuffer<FloatBuffer> sliceToAssign) {
        sliceToAssign.buffer().clear();
        this.buffer[z] = sliceToAssign;
    }

    @Override
    public VoxelBuffer<FloatBuffer> slice(int z) {
        VoxelBuffer<FloatBuffer> buf = this.buffer[z];
        buf.buffer().clear();
        return buf;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }
}

