/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.convert.ToUnsignedByte;

public final class ToUnsignedByteScaleByMinMaxValue
extends ToUnsignedByte {
    private float scale = 0.0f;
    private long subtract = 0L;

    public ToUnsignedByteScaleByMinMaxValue(long minValue, long maxValue) {
        this.setMinMaxValues(minValue, maxValue);
    }

    public void setMinMaxValues(long minValue, long maxValue) {
        this.scale = 255.0f / (float)(maxValue - minValue);
        this.subtract = minValue;
    }

    @Override
    protected void convertUnsignedShort(UnsignedShortBuffer in, UnsignedByteBuffer out) {
        out.putFloatClamped(this.scale * (float)((long)in.getUnsigned() - this.subtract));
    }

    @Override
    protected void convertUnsignedInt(UnsignedIntBuffer in, UnsignedByteBuffer out) {
        out.putFloatClamped(this.scale * (float)(in.getUnsigned() - this.subtract));
    }

    @Override
    protected void convertFloat(FloatBuffer in, UnsignedByteBuffer out) {
        out.putFloatClamped(this.scale * (in.get() - (float)this.subtract));
    }
}

