/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.convert.ToFloatNoScaling;
import org.anchoranalysis.image.voxel.convert.ToUnsignedByteNoScaling;
import org.anchoranalysis.image.voxel.convert.ToUnsignedInt;
import org.anchoranalysis.image.voxel.convert.ToUnsignedShortNoScaling;
import org.anchoranalysis.image.voxel.convert.VoxelsConverter;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;

public class VoxelsConverterMulti {
    public <S, T> Voxels<S> convert(VoxelsUntyped voxels, VoxelsFactoryTypeBound<T> outputVoxelsFactory) {
        if (voxels.getVoxelDataType().equals(outputVoxelsFactory.dataType())) {
            return voxels.any();
        }
        Voxels<T> voxelsToAssignTo = outputVoxelsFactory.createInitialized(voxels.extent());
        VoxelsConverter<S> converter = this.converterFor(outputVoxelsFactory.dataType());
        try {
            converter.copyFrom(voxels, voxelsToAssignTo);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
        return voxelsToAssignTo;
    }

    private <S> VoxelsConverter<S> converterFor(VoxelDataType outputVoxelType) {
        if (outputVoxelType.equals(UnsignedByteVoxelType.INSTANCE)) {
            return new ToUnsignedByteNoScaling();
        }
        if (outputVoxelType.equals(UnsignedShortVoxelType.INSTANCE)) {
            return new ToUnsignedShortNoScaling();
        }
        if (outputVoxelType.equals(FloatVoxelType.INSTANCE)) {
            return new ToFloatNoScaling();
        }
        if (outputVoxelType.equals(UnsignedIntVoxelType.INSTANCE)) {
            return new ToUnsignedInt();
        }
        throw new UnsupportedOperationException();
    }
}

