/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert.bufferedimage;

import java.awt.image.BufferedImage;
import java.util.function.Function;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.spatial.box.Extent;

public class BufferedImageFromVoxels {
    public static BufferedImage createGrayscaleByte(Voxels<UnsignedByteBuffer> voxels) throws CreateException {
        return BufferedImageFromVoxels.createFromArray(voxels, 10, UnsignedByteBuffer::array);
    }

    public static BufferedImage createGrayscaleShort(Voxels<UnsignedShortBuffer> voxels) throws CreateException {
        return BufferedImageFromVoxels.createFromArray(voxels, 11, UnsignedShortBuffer::array);
    }

    private static <T, S> BufferedImage createFromArray(Voxels<T> voxels, int imageType, Function<T, S> arrayFromBuffer) throws CreateException {
        Extent extent = voxels.extent();
        BufferedImageFromVoxels.checkExtentZ(extent);
        return BufferedImageFromVoxels.createGrayscaleFromArray(arrayFromBuffer.apply(voxels.sliceBuffer(0)), extent, imageType);
    }

    private static <S> BufferedImage createGrayscaleFromArray(S voxelArray, Extent extent, int imageType) {
        BufferedImage image = new BufferedImage(extent.x(), extent.y(), imageType);
        image.getWritableTile(0, 0).setDataElements(0, 0, extent.x(), extent.y(), voxelArray);
        return image;
    }

    private static void checkExtentZ(Extent extent) throws CreateException {
        if (extent.z() != 1) {
            throw new CreateException("The Z-dimension must be 1.");
        }
    }

    private BufferedImageFromVoxels() {
    }
}

