/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.convert.imglib2;

import java.util.List;
import java.util.function.Function;
import net.imglib2.img.AbstractNativeImg;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.spatial.box.Extent;

class WrapNativeImg {
    public static <S extends NativeType<S>, T extends ArrayDataAccess<T>, U> NativeImg<S, T> allSlices(Voxels<U> voxels, Function<U, T> extractArrayFromBuffer, Function<AbstractNativeImg<S, T>, S> deriveType) {
        long[] dim = WrapNativeImg.asArray3D(voxels.extent());
        PlanarImg image = new PlanarImg(WrapNativeImg.slicesFor(voxels, extractArrayFromBuffer), dim, new Fraction());
        return WrapNativeImg.updateType(image, deriveType);
    }

    public static <S extends NativeType<S>, T extends DataAccess, U> NativeImg<S, T> buffer(VoxelBuffer<U> buffer, Extent extent, Function<U, T> extractArrayFromBuffer, Function<AbstractNativeImg<S, T>, S> deriveType) {
        ArrayImg image = new ArrayImg((DataAccess)extractArrayFromBuffer.apply(buffer.buffer()), WrapNativeImg.asArray2D(extent), new Fraction());
        return WrapNativeImg.updateType(image, deriveType);
    }

    private static <S extends NativeType<S>, T> NativeImg<S, T> updateType(AbstractNativeImg<S, T> image, Function<AbstractNativeImg<S, T>, S> createType) {
        image.setLinkedType((NativeType)createType.apply(image));
        return image;
    }

    private static <T, U> List<T> slicesFor(Voxels<U> voxels, Function<U, T> transformSlice) {
        return FunctionalList.of(voxels.extent().streamOverZ().mapToObj(z -> transformSlice.apply(voxels.sliceBuffer(z))));
    }

    private static long[] asArray3D(Extent extent) {
        return new long[]{extent.x(), extent.y(), extent.z()};
    }

    private static long[] asArray2D(Extent extent) {
        return new long[]{extent.x(), extent.y()};
    }

    private WrapNativeImg() {
    }
}

