/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.extracter.predicate.VoxelsPredicate;
import org.anchoranalysis.image.voxel.iterator.MinMaxRange;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public interface VoxelsExtracter<T> {
    default public int voxel(int x, int y) {
        return this.voxel(x, y, 0);
    }

    default public int voxel(int x, int y, int z) {
        return this.voxel((ReadableTuple3i)new Point3i(x, y, z));
    }

    public int voxel(ReadableTuple3i var1);

    public Voxels<T> slice(int var1);

    public Voxels<T> region(BoundingBox var1, boolean var2);

    public void boxCopyTo(BoundingBox var1, Voxels<T> var2, BoundingBox var3);

    public void objectCopyTo(ObjectMask var1, Voxels<T> var2, BoundingBox var3);

    public Voxels<T> resizedXY(int var1, int var2, VoxelsResizer var3);

    public Voxels<T> projectMax();

    public Voxels<T> projectMean();

    public VoxelsPredicate voxelsEqualTo(int var1);

    public VoxelsPredicate voxelsGreaterThan(int var1);

    public long voxelWithMinIntensity();

    public long voxelWithMaxIntensity();

    public MinMaxRange voxelsWithMinMaxIntensity();
}

