/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import org.anchoranalysis.image.voxel.ExtentMatchHelper;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.extracter.predicate.PredicateImplementation;
import org.anchoranalysis.image.voxel.extracter.predicate.VoxelsPredicate;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

abstract class VoxelsExtracterBase<T>
implements VoxelsExtracter<T> {
    protected final Voxels<T> voxels;

    @Override
    public int voxel(ReadableTuple3i point) {
        T buffer = this.voxels.slices().slice(point.z()).buffer();
        int offset = this.voxels.slices().extent().offsetSlice(point);
        return this.voxelAtBufferIndex(buffer, offset);
    }

    @Override
    public Voxels<T> region(BoundingBox box, boolean reuseIfPossible) {
        if (reuseIfPossible) {
            return this.regionAvoidNewIfPossible(box);
        }
        return this.regionAlwaysNew(box);
    }

    @Override
    public Voxels<T> slice(int sliceIndex) {
        Voxels<T> bufferAccess = this.voxels.factory().createInitialized(this.voxels.extent().duplicateChangeZ(1));
        bufferAccess.slices().replaceSlice(0, this.voxels.slices().slice(sliceIndex));
        return bufferAccess;
    }

    @Override
    public void boxCopyTo(BoundingBox sourceBox, Voxels<T> voxelsDestination, BoundingBox destinationBox) {
        ExtentMatchHelper.checkExtentMatch(sourceBox, destinationBox);
        ReadableTuple3i sourceStart = sourceBox.cornerMin();
        ReadableTuple3i sourceEnd = sourceBox.calculateCornerMaxInclusive();
        Point3i relativePosition = destinationBox.relativePositionTo(sourceBox);
        Extent extent = this.voxels.extent();
        for (int z = sourceStart.z(); z <= sourceEnd.z(); ++z) {
            T sourceBuffer = this.voxels.sliceBuffer(z);
            T destinationBuffer = voxelsDestination.sliceBuffer(z + relativePosition.z());
            for (int y = sourceStart.y(); y <= sourceEnd.y(); ++y) {
                for (int x = sourceStart.x(); x <= sourceEnd.x(); ++x) {
                    int sourceIndex = extent.offset(x, y);
                    int destinationIndex = voxelsDestination.extent().offset(x + relativePosition.x(), y + relativePosition.y());
                    this.copySingleVoxelTo(sourceBuffer, sourceIndex, destinationBuffer, destinationIndex);
                }
            }
        }
    }

    @Override
    public Voxels<T> resizedXY(int sizeX, int sizeY, VoxelsResizer resizer) {
        Extent extentResized = new Extent(sizeX, sizeY, this.voxels.extent().z());
        Voxels<T> bufferTarget = this.voxels.factory().createInitialized(extentResized);
        assert (bufferTarget.slice(0).capacity() == extentResized.areaXY());
        resizer.resize(new VoxelsUntyped(this.voxels), new VoxelsUntyped(bufferTarget));
        assert (bufferTarget.slice(0).capacity() == extentResized.areaXY());
        return bufferTarget;
    }

    @Override
    public final Voxels<T> projectMax() {
        return this.project(this.createMaxIntensityBuffer(this.voxels.extent().flattenZ()));
    }

    @Override
    public final Voxels<T> projectMean() {
        return this.project(this.createMeanIntensityBuffer(this.voxels.extent().flattenZ()));
    }

    @Override
    public VoxelsPredicate voxelsEqualTo(int equalToValue) {
        return new PredicateImplementation<Object>(this.voxels, buffer -> this.bufferValueEqualTo(buffer, equalToValue));
    }

    @Override
    public VoxelsPredicate voxelsGreaterThan(int threshold) {
        return new PredicateImplementation<Object>(this.voxels, buffer -> this.bufferValueGreaterThan(buffer, threshold));
    }

    @Override
    public void objectCopyTo(ObjectMask object, Voxels<T> voxelsDestination, BoundingBox destinationBox) {
        ExtentMatchHelper.checkExtentMatch(object.boundingBox(), destinationBox);
        ReadableTuple3i sourceStart = object.boundingBox().cornerMin();
        ReadableTuple3i sourceEnd = object.boundingBox().calculateCornerMaxInclusive();
        Point3i relativePosition = destinationBox.relativePositionTo(object.boundingBox());
        BinaryValuesByte binaryValues = object.binaryValuesByte();
        for (int z = sourceStart.z(); z <= sourceEnd.z(); ++z) {
            T sourceBuffer = this.voxels.sliceBuffer(z);
            T destinationBuffer = voxelsDestination.sliceBuffer(z + relativePosition.z());
            UnsignedByteBuffer maskBuffer = object.sliceBufferGlobal(z);
            int sourceIndex = 0;
            for (int y = sourceStart.y(); y <= sourceEnd.y(); ++y) {
                for (int x = sourceStart.x(); x <= sourceEnd.x(); ++x) {
                    int destIndex = voxelsDestination.extent().offset(x + relativePosition.x(), y + relativePosition.y());
                    if (maskBuffer.getRaw() == binaryValues.getOn()) {
                        this.copySingleVoxelTo(sourceBuffer, sourceIndex, destinationBuffer, destIndex);
                    }
                    ++sourceIndex;
                }
            }
        }
    }

    protected abstract ProjectableBuffer<T> createMaxIntensityBuffer(Extent var1);

    protected abstract ProjectableBuffer<T> createMeanIntensityBuffer(Extent var1);

    protected abstract void copySingleVoxelTo(T var1, int var2, T var3, int var4);

    protected abstract int voxelAtBufferIndex(T var1, int var2);

    protected abstract boolean bufferValueGreaterThan(T var1, int var2);

    protected abstract boolean bufferValueEqualTo(T var1, int var2);

    private Voxels<T> regionAvoidNewIfPossible(BoundingBox box) {
        if (box.equals((Object)new BoundingBox(this.voxels.extent())) && box.cornerMin().x() == 0 && box.cornerMin().y() == 0 && box.cornerMin().z() == 0) {
            return this.voxels;
        }
        return this.regionAlwaysNew(box);
    }

    private Voxels<T> regionAlwaysNew(BoundingBox box) {
        Voxels<T> voxelsOut = this.voxels.factory().createInitialized(box.extent());
        this.boxCopyTo(box, voxelsOut, box.shiftToOrigin());
        return voxelsOut;
    }

    private Voxels<T> project(ProjectableBuffer<T> projection) {
        this.voxels.extent().iterateOverZ(z -> projection.addVoxelBuffer(this.voxels.slice(z)));
        return projection.completeProjection();
    }

    public VoxelsExtracterBase(Voxels<T> voxels) {
        this.voxels = voxels;
    }
}

