/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.extracter.AtCorner;
import org.anchoranalysis.image.voxel.extracter.FloatImplementation;
import org.anchoranalysis.image.voxel.extracter.UnsignedByteImplementation;
import org.anchoranalysis.image.voxel.extracter.UnsignedIntImplementation;
import org.anchoranalysis.image.voxel.extracter.UnsignedShortImplementation;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class VoxelsExtracterFactory {
    public static VoxelsExtracter<UnsignedByteBuffer> createUnsignedByte(Voxels<UnsignedByteBuffer> voxels) {
        return new UnsignedByteImplementation(voxels);
    }

    public static VoxelsExtracter<UnsignedShortBuffer> createUnsignedShort(Voxels<UnsignedShortBuffer> voxels) {
        return new UnsignedShortImplementation(voxels);
    }

    public static VoxelsExtracter<UnsignedIntBuffer> createUnsignedInt(Voxels<UnsignedIntBuffer> voxels) {
        return new UnsignedIntImplementation(voxels);
    }

    public static VoxelsExtracter<FloatBuffer> createFloat(Voxels<FloatBuffer> voxels) {
        return new FloatImplementation(voxels);
    }

    public static <T> VoxelsExtracter<T> atCorner(ReadableTuple3i corner, VoxelsExtracter<T> delegate) {
        return new AtCorner<T>(corner, delegate);
    }

    private VoxelsExtracterFactory() {
    }
}

