/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.factory;

import com.google.common.base.Preconditions;
import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public interface VoxelsFactoryTypeBound<T> {
    public Voxels<T> create(SliceBufferIndex<T> var1);

    public Voxels<T> createInitialized(Extent var1);

    public Voxels<T> createUninitialized(Extent var1);

    public VoxelDataType dataType();

    default public Voxels<T> createForVoxelBuffer(VoxelBuffer<T> buffer, Extent extent) {
        Preconditions.checkArgument((extent.areaXY() == buffer.capacity() ? 1 : 0) != 0);
        Voxels<T> out = this.createUninitialized(extent);
        out.replaceSlice(0, buffer);
        return out;
    }

    default public BoundedVoxels<T> createBounded(BoundingBox box) {
        return new BoundedVoxels<T>(box, this.createInitialized(box.extent()));
    }
}

