/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import com.google.common.base.Preconditions;
import java.util.function.IntBinaryOperator;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedBufferAsInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsBoundingBox;
import org.anchoranalysis.image.voxel.iterator.MinMaxRange;
import org.anchoranalysis.image.voxel.iterator.RetrieveBufferForSlice;
import org.anchoranalysis.image.voxel.iterator.RetrieveBuffersForThreeSlices;
import org.anchoranalysis.image.voxel.iterator.RetrieveBuffersForTwoSlices;
import org.anchoranalysis.image.voxel.iterator.process.ProcessKernelPointCursor;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPointAndIndex;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinary;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferTernary;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferBinary;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferBinaryMixed;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferUnary;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferUnaryWithPoint;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;

public class IterateVoxelsAll {
    public static void withPoint(Extent extent, ProcessPoint process) {
        IterateVoxelsBoundingBox.withPoint(new BoundingBox(extent), process);
    }

    public static void withPointAndIndex(Extent extent, ProcessPointAndIndex process) {
        IterateVoxelsBoundingBox.withPointAndIndex(new BoundingBox(extent), process);
    }

    public static void withCursor(BinaryVoxels<UnsignedByteBuffer> voxels, KernelApplicationParameters parameters, ProcessKernelPointCursor process) {
        KernelPointCursor cursor = new KernelPointCursor(0, new Point3i(), voxels.extent(), voxels.binaryValues().asByte(), parameters);
        Extent extent = voxels.extent();
        Point3i point = cursor.getPoint();
        point.setZ(0);
        while (point.z() < extent.z()) {
            cursor.setIndex(0);
            process.notifyChangeSlice(point.z());
            point.setY(0);
            while (point.y() < extent.y()) {
                point.setX(0);
                while (point.x() < extent.x()) {
                    process.process(cursor);
                    cursor.incrementIndexOnly();
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static <T> void withBuffer(Voxels<T> voxels, ProcessBufferUnary<T> process) {
        IterateVoxelsAll.withPoint(voxels.extent(), new RetrieveBufferForSlice<T>(voxels, process));
    }

    public static <S, T> void withTwoBuffersAndPoint(Voxels<S> voxels1, Voxels<T> voxels2, ProcessBufferBinary<S, T> process) {
        Preconditions.checkArgument((boolean)voxels1.extent().equals((Object)voxels2.extent()));
        IterateVoxelsAll.withPoint(voxels1.extent(), new RetrieveBuffersForTwoSlices<S, T>(voxels1, voxels2, process));
    }

    public static <T> void withThreeBuffers(Voxels<T> voxels1, Voxels<T> voxels2, Voxels<T> voxels3, ProcessBufferTernary<T> process) {
        Preconditions.checkArgument((boolean)voxels1.extent().equals((Object)voxels2.extent()));
        Preconditions.checkArgument((boolean)voxels2.extent().equals((Object)voxels3.extent()));
        IterateVoxelsAll.withPoint(voxels1.extent(), new RetrieveBuffersForThreeSlices<T>(voxels1, voxels2, voxels3, process));
    }

    public static <T> void withVoxelBuffer(Voxels<T> voxels, ProcessVoxelBufferUnary<T> process) {
        int volumeXY = voxels.extent().areaXY();
        voxels.extent().iterateOverZ(z -> {
            VoxelBuffer buffer = voxels.slice(z);
            for (int offset = 0; offset < volumeXY; ++offset) {
                process.process(buffer, offset);
            }
        });
    }

    public static <T, E extends Exception> void withVoxelBuffer(Voxels<T> voxels, ProcessVoxelBufferUnaryWithPoint<T, E> process) throws E {
        Extent extentVoxels = voxels.extent();
        Point3i point = new Point3i();
        point.setZ(0);
        while (point.z() < extentVoxels.z()) {
            VoxelBuffer<T> buffer = voxels.slice(point.z());
            int offset = 0;
            point.setY(0);
            while (point.y() < extentVoxels.y()) {
                point.setX(0);
                while (point.x() < extentVoxels.x()) {
                    process.process(point, buffer, offset++);
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static <S, T> void withTwoVoxelBuffers(Voxels<S> voxels1, Voxels<T> voxels2, ProcessVoxelBufferBinary<S, T> process) {
        Preconditions.checkArgument((boolean)voxels1.extent().equals((Object)voxels2.extent()));
        int volumeXY = voxels1.extent().areaXY();
        voxels1.extent().iterateOverZ(z -> {
            VoxelBuffer buffer1 = voxels1.slice(z);
            VoxelBuffer buffer2 = voxels2.slice(z);
            for (int offset = 0; offset < volumeXY; ++offset) {
                process.process(buffer1, buffer2, offset);
            }
        });
    }

    public static <S, T> void withTwoMixedBuffers(Voxels<S> voxels1, Voxels<T> voxels2, ProcessVoxelBufferBinaryMixed<S, T> process) {
        Preconditions.checkArgument((boolean)voxels1.extent().equals((Object)voxels2.extent()));
        int sizeX = voxels1.extent().x();
        int sizeY = voxels1.extent().y();
        voxels1.extent().iterateOverZ(z -> {
            VoxelBuffer buffer1 = voxels1.slice(z);
            Object buffer2 = voxels2.slice(z).buffer();
            int offset = 0;
            for (int y = 0; y < sizeY; ++y) {
                for (int x = 0; x < sizeX; ++x) {
                    process.process(new Point3i(x, y, z), buffer1, buffer2, offset++);
                }
            }
        });
    }

    public static <T> boolean anyPredicateMatch(Voxels<T> voxels, Predicate<T> predicate) {
        int zMax = voxels.extent().z();
        for (int z = 0; z < zMax; ++z) {
            VoxelBuffer<T> buffer = voxels.slice(z);
            while (buffer.hasRemaining()) {
                if (!predicate.test(buffer.buffer())) continue;
                return true;
            }
        }
        return false;
    }

    public static void changeIntensity(Voxels<?> voxels, IntUnaryOperator operator) {
        voxels.slices().iterateOverSlicesAndOffsets((buffer, offset) -> {
            int value = buffer.getInt(offset);
            buffer.putInt(offset, operator.applyAsInt(value));
        });
    }

    public static <T extends UnsignedBufferAsInt> int intensityMin(Voxels<T> voxels) {
        int min = Integer.MAX_VALUE;
        int sizeXY = voxels.extent().areaXY();
        for (int z = 0; z < voxels.extent().z(); ++z) {
            UnsignedBufferAsInt buffer = (UnsignedBufferAsInt)voxels.sliceBuffer(z);
            for (int offset = 0; offset < sizeXY; ++offset) {
                int val = buffer.getUnsigned(offset);
                if (val >= min) continue;
                min = val;
            }
        }
        return min;
    }

    public static <T extends UnsignedBufferAsInt> int intensityMax(Voxels<T> voxels) {
        int max = Integer.MIN_VALUE;
        int sizeXY = voxels.extent().areaXY();
        for (int z = 0; z < voxels.extent().z(); ++z) {
            UnsignedBufferAsInt buffer = (UnsignedBufferAsInt)voxels.sliceBuffer(z);
            for (int offset = 0; offset < sizeXY; ++offset) {
                int val = buffer.getUnsigned(offset);
                if (val <= max) continue;
                max = val;
            }
        }
        return max;
    }

    public static <T extends UnsignedBufferAsInt> MinMaxRange intensityMinMax(Voxels<T> voxels) {
        int max = Integer.MIN_VALUE;
        int min = Integer.MAX_VALUE;
        int sizeXY = voxels.extent().areaXY();
        for (int z = 0; z < voxels.extent().z(); ++z) {
            UnsignedBufferAsInt buffer = (UnsignedBufferAsInt)voxels.sliceBuffer(z);
            for (int offset = 0; offset < sizeXY; ++offset) {
                int val = buffer.getUnsigned(offset);
                if (val > max) {
                    max = val;
                }
                if (val >= min) continue;
                min = val;
            }
        }
        return new MinMaxRange(min, max);
    }

    public static void assignEachMatchingPoint(Voxels<?> voxels, IntPredicate predicate, int valueToAssign) {
        voxels.slices().iterateOverSlicesAndOffsets((buffer, offset) -> {
            if (predicate.test(buffer.getInt(offset))) {
                buffer.putInt(offset, valueToAssign);
            }
        });
    }

    public static void binaryOperation(Voxels<UnsignedByteBuffer> voxelsIn1, Voxels<UnsignedByteBuffer> voxelsIn2, Voxels<UnsignedByteBuffer> voxelsOut, IntBinaryOperator operation) {
        Preconditions.checkArgument((boolean)voxelsIn1.extent().equals((Object)voxelsIn2.extent()));
        Preconditions.checkArgument((boolean)voxelsIn2.extent().equals((Object)voxelsOut.extent()));
        voxelsOut.extent().iterateOverZ(z -> {
            UnsignedByteBuffer in1 = (UnsignedByteBuffer)voxelsIn1.sliceBuffer(z);
            UnsignedByteBuffer in2 = (UnsignedByteBuffer)voxelsIn2.sliceBuffer(z);
            UnsignedByteBuffer out = (UnsignedByteBuffer)voxelsOut.sliceBuffer(z);
            while (in1.hasRemaining()) {
                out.putUnsigned(operation.applyAsInt(in1.getUnsigned(), in2.getUnsigned()));
            }
            assert (!in2.hasRemaining());
            assert (!out.hasRemaining());
        });
    }

    private IterateVoxelsAll() {
    }
}

