/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import java.util.Optional;
import java.util.function.Predicate;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.RetrieveBufferForSlice;
import org.anchoranalysis.image.voxel.iterator.predicate.PredicateBufferBinary;
import org.anchoranalysis.image.voxel.iterator.predicate.PredicateKernelPointCursor;
import org.anchoranalysis.image.voxel.iterator.process.ProcessKernelPointCursor;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPointAndIndex;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinary;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinaryMixed;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferTernary;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class IterateVoxelsBoundingBox {
    public static void withPoint(BoundingBox box, ProcessPoint process) {
        ReadableTuple3i cornerMin = box.cornerMin();
        ReadableTuple3i cornerMax = box.calculateCornerMaxInclusive();
        Point3i point = new Point3i();
        point.setZ(cornerMin.z());
        while (point.z() <= cornerMax.z()) {
            process.notifyChangeSlice(point.z());
            point.setY(cornerMin.y());
            while (point.y() <= cornerMax.y()) {
                process.notifyChangeY(point.y());
                point.setX(cornerMin.x());
                while (point.x() <= cornerMax.x()) {
                    process.process(point);
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static void withPointAndIndex(BoundingBox box, ProcessPointAndIndex process) {
        ReadableTuple3i cornerMin = box.cornerMin();
        ReadableTuple3i cornerMax = box.calculateCornerMaxInclusive();
        Point3i point = new Point3i();
        point.setZ(cornerMin.z());
        while (point.z() <= cornerMax.z()) {
            process.notifyChangeSlice(point.z());
            int index = 0;
            point.setY(cornerMin.y());
            while (point.y() <= cornerMax.y()) {
                process.notifyChangeY(point.y());
                point.setX(cornerMin.x());
                while (point.x() <= cornerMax.x()) {
                    process.process(point, index++);
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static void withMatchingPoints(BoundingBox box, Predicate<Point3i> predicate, ProcessPoint process) {
        ReadableTuple3i cornerMin = box.cornerMin();
        ReadableTuple3i cornerMax = box.calculateCornerMaxInclusive();
        Point3i point = new Point3i();
        point.setZ(cornerMin.z());
        while (point.z() <= cornerMax.z()) {
            process.notifyChangeSlice(point.z());
            point.setY(cornerMin.y());
            while (point.y() <= cornerMax.y()) {
                process.notifyChangeY(point.y());
                point.setX(cornerMin.x());
                while (point.x() <= cornerMax.x()) {
                    if (predicate.test(point)) {
                        process.process(point);
                    }
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static <T> void withBuffer(BoundingBox box, Voxels<T> voxels, ProcessBufferUnary<T> process) {
        IterateVoxelsBoundingBox.withPoint(box, new RetrieveBufferForSlice<T>(voxels, process));
    }

    public static <T> void withTwoBuffers(BoundingBox box, ReadableTuple3i shiftForSecond, Voxels<T> voxels1, Voxels<T> voxels2, ProcessBufferBinary<T, T> process) {
        ReadableTuple3i max = box.calculateCornerMaxExclusive();
        Point3i point = new Point3i();
        point.setZ(box.cornerMin().z());
        while (point.z() < max.z()) {
            process.notifyChangeSlice(point.z());
            T buffer1 = voxels1.sliceBuffer(point.z());
            T buffer2 = voxels2.sliceBuffer(point.z() + shiftForSecond.z());
            point.setY(box.cornerMin().y());
            while (point.y() < max.y()) {
                int yOther = point.y() + shiftForSecond.y();
                point.setX(box.cornerMin().x());
                while (point.x() < max.x()) {
                    int xOther = point.x() + shiftForSecond.x();
                    int offset1 = voxels1.extent().offsetSlice((ReadableTuple3i)point);
                    int offset2 = voxels2.extent().offset(xOther, yOther);
                    process.process(point, buffer1, buffer2, offset1, offset2);
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static <S, T> void withTwoMixedBuffers(BoundingBox box, ReadableTuple3i shiftForSecond, Voxels<S> voxels1, Voxels<T> voxels2, ProcessBufferBinaryMixed<S, T> process) {
        ReadableTuple3i max = box.calculateCornerMaxExclusive();
        Point3i point = new Point3i();
        point.setZ(box.cornerMin().z());
        while (point.z() < max.z()) {
            process.notifyChangeSlice(point.z());
            VoxelBuffer<S> buffer1 = voxels1.slice(point.z());
            T buffer2 = voxels2.sliceBuffer(point.z() + shiftForSecond.z());
            point.setY(box.cornerMin().y());
            while (point.y() < max.y()) {
                int yOther = point.y() + shiftForSecond.y();
                point.setX(box.cornerMin().x());
                while (point.x() < max.x()) {
                    int xOther = point.x() + shiftForSecond.x();
                    int offset1 = voxels1.extent().offsetSlice((ReadableTuple3i)point);
                    int offset2 = voxels2.extent().offset(xOther, yOther);
                    process.process(point, buffer1, buffer2, offset1, offset2);
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static <T> Optional<Point3i> withTwoBuffersUntil(BoundingBox box, ReadableTuple3i shiftForSecond, Voxels<T> voxels1, Voxels<T> voxels2, PredicateBufferBinary<T> predicate) {
        ReadableTuple3i max = box.calculateCornerMaxExclusive();
        Point3i point = new Point3i();
        point.setZ(box.cornerMin().z());
        while (point.z() < max.z()) {
            predicate.notifyChangeSlice(point.z());
            T buffer1 = voxels1.sliceBuffer(point.z());
            T buffer2 = voxels2.sliceBuffer(point.z() + shiftForSecond.z());
            point.setY(box.cornerMin().y());
            while (point.y() < max.y()) {
                int yOther = point.y() + shiftForSecond.y();
                point.setX(box.cornerMin().x());
                while (point.x() < max.x()) {
                    int offset2;
                    int xOther = point.x() + shiftForSecond.x();
                    int offset1 = voxels1.extent().offsetSlice((ReadableTuple3i)point);
                    if (predicate.test(point, buffer1, buffer2, offset1, offset2 = voxels2.extent().offset(xOther, yOther))) {
                        return Optional.of(point);
                    }
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
        return Optional.empty();
    }

    public static <T> void withThreeBuffers(BoundingBox box, ReadableTuple3i shiftForSecond, ReadableTuple3i shiftForThird, Voxels<T> voxels1, Voxels<T> voxels2, Voxels<T> voxels3, ProcessBufferTernary<T> process) {
        ReadableTuple3i max = box.calculateCornerMaxExclusive();
        Point3i point = new Point3i();
        point.setZ(box.cornerMin().z());
        while (point.z() < max.z()) {
            process.notifyChangeSlice(point.z());
            T buffer1 = voxels1.sliceBuffer(point.z());
            T buffer2 = voxels2.sliceBuffer(point.z() + shiftForSecond.z());
            T buffer3 = voxels3.sliceBuffer(point.z() + shiftForThird.z());
            point.setY(box.cornerMin().y());
            while (point.y() < max.y()) {
                int ySecond = point.y() + shiftForSecond.y();
                int yThird = point.y() + shiftForThird.y();
                point.setX(box.cornerMin().x());
                while (point.x() < max.x()) {
                    int offset1 = voxels1.extent().offsetSlice((ReadableTuple3i)point);
                    int offset2 = voxels2.extent().offset(point.x() + shiftForSecond.x(), ySecond);
                    int offset3 = voxels3.extent().offset(point.x() + shiftForThird.x(), yThird);
                    process.process(point, buffer1, buffer2, buffer3, offset1, offset2, offset3);
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static void withCursor(BinaryVoxels<UnsignedByteBuffer> voxels, BoundingBox box, KernelApplicationParameters parameters, ProcessKernelPointCursor process) {
        KernelPointCursor cursor = new KernelPointCursor(voxels.extent().offset(box.cornerMin()), new Point3i(box.cornerMin()), voxels.extent(), voxels.binaryValues().asByte(), parameters);
        Extent extent = voxels.extent();
        Point3i point = cursor.getPoint();
        ReadableTuple3i cornerMin = box.cornerMin();
        ReadableTuple3i cornerMax = box.calculateCornerMaxExclusive();
        point.setZ(cornerMin.z());
        while (point.z() < cornerMax.z()) {
            cursor.setIndex(extent.offset(cornerMin.x(), cornerMin.y()));
            process.notifyChangeSlice(point.z());
            point.setY(cornerMin.y());
            while (point.y() < cornerMax.y()) {
                point.setX(cornerMin.x());
                while (point.x() < cornerMax.x()) {
                    process.process(cursor);
                    cursor.incrementIndexOnly();
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static boolean withCursorUntil(BinaryVoxels<UnsignedByteBuffer> voxels, BoundingBox box, KernelApplicationParameters parameters, PredicateKernelPointCursor predicate) {
        KernelPointCursor cursor = new KernelPointCursor(voxels.extent().offset(box.cornerMin()), new Point3i(box.cornerMin()), voxels.extent(), voxels.binaryValues().asByte(), parameters);
        Extent extent = voxels.extent();
        Point3i point = cursor.getPoint();
        ReadableTuple3i cornerMin = box.cornerMin();
        ReadableTuple3i cornerMax = box.calculateCornerMaxExclusive();
        point.setZ(cornerMin.z());
        while (point.z() < cornerMax.z()) {
            cursor.setIndex(extent.offset(cornerMin.x(), cornerMin.y()));
            predicate.notifyChangeSlice(point.z());
            point.setY(cornerMin.y());
            while (point.y() < cornerMax.y()) {
                point.setX(cornerMin.x());
                while (point.x() < cornerMax.x()) {
                    if (predicate.test(cursor)) {
                        return true;
                    }
                    cursor.incrementIndexOnly();
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
        return false;
    }

    private IterateVoxelsBoundingBox() {
    }
}

