/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.function.IntPredicate;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.image.voxel.ExtentMatchHelper;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsBoundingBox;
import org.anchoranalysis.image.voxel.iterator.RequireIntersectionWithObject;
import org.anchoranalysis.image.voxel.iterator.RetrieveBuffersForTwoSlices;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinary;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferBinary;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferBinaryMixed;
import org.anchoranalysis.image.voxel.iterator.process.voxelbuffer.ProcessVoxelBufferUnary;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class IterateVoxelsObjectMask {
    public static void withPoint(ObjectMask object, ProcessPoint process) {
        IterateVoxelsBoundingBox.withPoint(object.boundingBox(), new RequireIntersectionWithObject(process, object));
    }

    public static void withPoint(ObjectMask firstMask, Optional<ObjectMask> secondMask, ProcessPoint process) {
        if (secondMask.isPresent()) {
            Optional intersection = firstMask.boundingBox().intersection().with(secondMask.get().boundingBox());
            intersection.ifPresent(box -> IterateVoxelsBoundingBox.withPoint(box, IterateVoxelsObjectMask.requireIntersectionTwice(firstMask, (ObjectMask)secondMask.get(), process)));
        } else {
            IterateVoxelsObjectMask.withPoint(firstMask, process);
        }
    }

    public static <T> void withBuffer(ObjectMask object, Voxels<T> voxels, ProcessBufferUnary<T> process) {
        Extent extent = voxels.extent();
        ReadableTuple3i cornerMin = object.boundingBox().cornerMin();
        byte valueOn = object.binaryValuesByte().getOn();
        ReadableTuple3i cornerMax = object.boundingBox().calculateCornerMaxExclusive();
        Point3i point = new Point3i();
        point.setZ(cornerMin.z());
        while (point.z() < cornerMax.z()) {
            T buffer = voxels.sliceBuffer(point.z());
            UnsignedByteBuffer bufferObject = object.sliceBufferGlobal(point.z());
            process.notifyChangeSlice(point.z());
            point.setY(cornerMin.y());
            while (point.y() < cornerMax.y()) {
                int offset = extent.offset(cornerMin.x(), point.y());
                point.setX(cornerMin.x());
                while (point.x() < cornerMax.x()) {
                    if (bufferObject.getRaw() == valueOn) {
                        process.process(point, buffer, offset);
                    }
                    ++offset;
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    public static <S, T> void withTwoBuffers(ObjectMask object, Voxels<S> voxels1, Voxels<T> voxels2, ProcessBufferBinary<S, T> process) {
        Preconditions.checkArgument((boolean)voxels1.extent().equals((Object)voxels2.extent()));
        IterateVoxelsObjectMask.withPoint(object, new RetrieveBuffersForTwoSlices<S, T>(voxels1, voxels2, process));
    }

    public static <T> void withVoxelBuffer(ObjectMask object, Voxels<T> voxels, ProcessVoxelBufferUnary<T> process) {
        IterateVoxelsObjectMask.withVoxelBuffer(object, voxels, Optional.empty(), process);
    }

    public static <T> void withVoxelBuffer(ObjectMask object, Voxels<T> voxels, Optional<BoundingBox> restrictTo, ProcessVoxelBufferUnary<T> process) {
        BoundingBox boxVoxels = restrictTo.orElseGet(() -> object.boundingBox().clampTo(voxels.extent()));
        Preconditions.checkArgument((boolean)voxels.extent().contains(boxVoxels));
        Optional restrictToIntersection = OptionalUtilities.flatMap(restrictTo, box -> box.intersection().with(object.boundingBox()));
        if (restrictTo.isPresent() && !restrictToIntersection.isPresent()) {
            return;
        }
        BoundingBox iterateBox = restrictToIntersection.map(box -> box.relativePositionToBox(object.boundingBox())).orElseGet(() -> ((BoundingBox)boxVoxels).shiftToOrigin());
        IterateVoxelsObjectMask.callEachPoint(object, voxels, boxVoxels, iterateBox, process);
    }

    public static <S, T> void withTwoVoxelBuffers(ObjectMask object, Voxels<S> voxels1, Voxels<T> voxels2, ProcessVoxelBufferBinary<S, T> process) {
        Preconditions.checkArgument((boolean)voxels1.extent().equals((Object)voxels2.extent()));
        ReadableTuple3i cornerMin = object.boundingBox().cornerMin();
        ReadableTuple3i cornerMax = object.boundingBox().calculateCornerMaxInclusive();
        byte maskOn = object.binaryValuesByte().getOn();
        Extent e = voxels1.extent();
        for (int z = cornerMin.z(); z <= cornerMax.z(); ++z) {
            VoxelBuffer<S> buffer = voxels1.slice(z);
            VoxelBuffer<T> bufferFinalized = voxels2.slice(z);
            UnsignedByteBuffer bufferMask = object.sliceBufferGlobal(z);
            int offset = 0;
            for (int y = cornerMin.y(); y <= cornerMax.y(); ++y) {
                for (int x = cornerMin.x(); x <= cornerMax.x(); ++x) {
                    if (bufferMask.getRaw(offset) == maskOn) {
                        process.process(buffer, bufferFinalized, e.offset(x, y));
                    }
                    ++offset;
                }
            }
        }
    }

    public static <S, T> void withTwoMixedBuffers(ObjectMask object, Voxels<S> voxels1, Voxels<T> voxels2, ProcessVoxelBufferBinaryMixed<S, T> process) {
        Preconditions.checkArgument((boolean)voxels1.extent().equals((Object)voxels2.extent()));
        ReadableTuple3i cornerMin = object.boundingBox().cornerMin();
        ReadableTuple3i cornerMax = object.boundingBox().calculateCornerMaxInclusive();
        byte maskOn = object.binaryValuesByte().getOn();
        Extent e = voxels1.extent();
        for (int z = cornerMin.z(); z <= cornerMax.z(); ++z) {
            VoxelBuffer<S> buffer = voxels1.slice(z);
            T bufferFinalized = voxels2.sliceBuffer(z);
            UnsignedByteBuffer bufferMask = object.sliceBufferGlobal(z);
            int offset = 0;
            for (int y = cornerMin.y(); y <= cornerMax.y(); ++y) {
                for (int x = cornerMin.x(); x <= cornerMax.x(); ++x) {
                    if (bufferMask.getRaw(offset) == maskOn) {
                        process.process(new Point3i(x, y, z), buffer, bufferFinalized, e.offset(x, y));
                    }
                    ++offset;
                }
            }
        }
    }

    public static <T> boolean allMatchIntensity(ObjectMask object, Voxels<T> voxels, IntPredicate predicate) {
        ReadableTuple3i cornerMin = object.boundingBox().cornerMin();
        ReadableTuple3i cornerMax = object.boundingBox().calculateCornerMaxExclusive();
        byte maskMatchValue = object.binaryValuesByte().getOn();
        Extent extentVoxels = voxels.extent();
        Point3i point = new Point3i();
        point.setZ(cornerMin.z());
        while (point.z() < cornerMax.z()) {
            VoxelBuffer<T> buffer = voxels.slice(point.z());
            UnsignedByteBuffer sliceMask = object.sliceBufferGlobal(point.z());
            point.setY(cornerMin.y());
            while (point.y() < cornerMax.y()) {
                point.setX(cornerMin.x());
                while (point.x() < cornerMax.x()) {
                    int offset;
                    int voxelIntensity;
                    if (sliceMask.getRaw() == maskMatchValue && !predicate.test(voxelIntensity = buffer.getInt(offset = extentVoxels.offsetSlice((ReadableTuple3i)point)))) {
                        return false;
                    }
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
        return true;
    }

    private static <T> void callEachPoint(ObjectMask object, Voxels<T> voxels, BoundingBox boxVoxels, BoundingBox boxRelativeToObject, ProcessVoxelBufferUnary<T> process) {
        assert (voxels.extent().contains(boxVoxels));
        ExtentMatchHelper.checkExtentMatch(boxVoxels, boxRelativeToObject);
        ReadableTuple3i cornerMin = boxVoxels.cornerMin();
        ReadableTuple3i cornerMax = boxVoxels.calculateCornerMaxExclusive();
        Point3i maskShift = Point3i.immutableSubtract((ReadableTuple3i)boxRelativeToObject.cornerMin(), (ReadableTuple3i)cornerMin);
        byte maskMatchValue = object.binaryValuesByte().getOn();
        Extent extentVoxels = voxels.extent();
        Extent extentObject = object.extent();
        Point3i point = new Point3i();
        point.setZ(cornerMin.z());
        while (point.z() < cornerMax.z()) {
            VoxelBuffer<T> buffer = voxels.slice(point.z());
            UnsignedByteBuffer sliceMask = object.sliceBufferLocal(point.z() + maskShift.z());
            point.setY(cornerMin.y());
            while (point.y() < cornerMax.y()) {
                point.setX(cornerMin.x());
                while (point.x() < cornerMax.x()) {
                    int indexMask = extentObject.offset(point.x() + maskShift.x(), point.y() + maskShift.y());
                    if (sliceMask.getRaw(indexMask) == maskMatchValue) {
                        int offset = extentVoxels.offsetSlice((ReadableTuple3i)point);
                        process.process(buffer, offset);
                    }
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    private static ProcessPoint requireIntersectionTwice(ObjectMask object1, ObjectMask object2, ProcessPoint processor) {
        RequireIntersectionWithObject inner = new RequireIntersectionWithObject(processor, object2);
        return new RequireIntersectionWithObject(inner, object1);
    }

    private IterateVoxelsObjectMask() {
    }
}

