/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.Point3i;

final class RequireIntersectionWithObject
implements ProcessPoint {
    private final ProcessPoint process;
    private final ObjectMask objectMask;
    private final byte byteOn;
    private UnsignedByteBuffer bufferObject;

    public RequireIntersectionWithObject(ProcessPoint process, ObjectMask objectMask) {
        this.process = process;
        this.objectMask = objectMask;
        this.byteOn = objectMask.binaryValuesByte().getOn();
    }

    @Override
    public void notifyChangeSlice(int z) {
        this.process.notifyChangeSlice(z);
        this.bufferObject = this.objectMask.sliceBufferGlobal(z);
    }

    @Override
    public void notifyChangeY(int y) {
        this.process.notifyChangeY(y);
    }

    @Override
    public void process(Point3i point) {
        if (this.isPointOnObject(point)) {
            this.process.process(point);
        }
    }

    private boolean isPointOnObject(Point3i point) {
        int offsetMask = this.objectMask.offsetGlobal(point.x(), point.y());
        return this.bufferObject.getRaw(offsetMask) == this.byteOn;
    }
}

