/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.spatial.point.Point3i;

final class RetrieveBufferForSlice<T>
implements ProcessPoint {
    private final Voxels<T> voxels;
    private final ProcessBufferUnary<T> processor;
    private T bufferSlice;
    private int offsetWithinSlice;

    @Override
    public void notifyChangeSlice(int z) {
        this.processor.notifyChangeSlice(z);
        this.offsetWithinSlice = 0;
        this.bufferSlice = this.voxels.sliceBuffer(z);
    }

    @Override
    public void process(Point3i point) {
        this.processor.process(point, this.bufferSlice, this.offsetWithinSlice++);
    }

    public RetrieveBufferForSlice(Voxels<T> voxels, ProcessBufferUnary<T> processor) {
        this.voxels = voxels;
        this.processor = processor;
    }
}

