/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferTernary;
import org.anchoranalysis.spatial.point.Point3i;

final class RetrieveBuffersForThreeSlices<T>
implements ProcessPoint {
    private final Voxels<T> voxels1;
    private final Voxels<T> voxels2;
    private final Voxels<T> voxels3;
    private final ProcessBufferTernary<T> processor;
    private T bufferSlice1;
    private T bufferSlice2;
    private T bufferSlice3;
    private int offsetWithinSlice;

    @Override
    public void notifyChangeSlice(int z) {
        this.processor.notifyChangeSlice(z);
        this.offsetWithinSlice = 0;
        this.bufferSlice1 = this.voxels1.sliceBuffer(z);
        this.bufferSlice2 = this.voxels2.sliceBuffer(z);
        this.bufferSlice3 = this.voxels3.sliceBuffer(z);
    }

    @Override
    public void process(Point3i point) {
        int offset = this.offsetWithinSlice++;
        this.processor.process(point, this.bufferSlice1, this.bufferSlice2, this.bufferSlice3, offset, offset, offset);
    }

    public RetrieveBuffersForThreeSlices(Voxels<T> voxels1, Voxels<T> voxels2, Voxels<T> voxels3, ProcessBufferTernary<T> processor) {
        this.voxels1 = voxels1;
        this.voxels2 = voxels2;
        this.voxels3 = voxels3;
        this.processor = processor;
    }
}

