/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.iterator.process.ProcessPoint;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinary;
import org.anchoranalysis.spatial.point.Point3i;

final class RetrieveBuffersForTwoSlices<S, T>
implements ProcessPoint {
    private final Voxels<S> voxels1;
    private final Voxels<T> voxels2;
    private final ProcessBufferBinary<S, T> processor;
    private S bufferSlice1;
    private T bufferSlice2;
    private int offsetWithinSlice;

    @Override
    public void notifyChangeSlice(int z) {
        this.processor.notifyChangeSlice(z);
        this.offsetWithinSlice = 0;
        this.bufferSlice1 = this.voxels1.sliceBuffer(z);
        this.bufferSlice2 = this.voxels2.sliceBuffer(z);
    }

    @Override
    public void process(Point3i point) {
        int offset = this.offsetWithinSlice++;
        this.processor.process(point, this.bufferSlice1, this.bufferSlice2, offset, offset);
    }

    public RetrieveBuffersForTwoSlices(Voxels<S> voxels1, Voxels<T> voxels2, ProcessBufferBinary<S, T> processor) {
        this.voxels1 = voxels1;
        this.voxels2 = voxels2;
        this.processor = processor;
    }
}

