/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.intersecting;

import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.intersecting.IterateVoxelsIntersectingBounded;
import org.anchoranalysis.image.voxel.iterator.predicate.PredicateTwoBytes;
import org.anchoranalysis.math.arithmetic.Counter;

public class CountVoxelsIntersectingBounded {
    public static int countByte(BoundedVoxels<UnsignedByteBuffer> voxels1, BoundedVoxels<UnsignedByteBuffer> voxels2, PredicateTwoBytes predicate) {
        Counter counter = new Counter();
        IterateVoxelsIntersectingBounded.withTwoBuffers(voxels1, voxels2, (point, buffer1, buffer2, offset1, offset2) -> {
            if (predicate.test(buffer1.getRaw(offset1), buffer2.getRaw(offset2))) {
                counter.increment();
            }
        });
        return counter.getCount();
    }

    public static int countByteMasked(Voxels<UnsignedByteBuffer> maskGlobal, byte onMaskGlobal, BoundedVoxels<UnsignedByteBuffer> voxels1, BoundedVoxels<UnsignedByteBuffer> voxels2, PredicateTwoBytes predicate) {
        Counter counter = new Counter();
        IterateVoxelsIntersectingBounded.withTwoBuffers(maskGlobal, onMaskGlobal, voxels1, voxels2, (point, buffer1, buffer2, offset1, offset2) -> {
            if (predicate.test(buffer1.getRaw(offset1), buffer2.getRaw(offset2))) {
                counter.increment();
            }
        });
        return counter.getCount();
    }

    private CountVoxelsIntersectingBounded() {
    }
}

