/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.intersecting;

import java.util.Optional;
import org.anchoranalysis.image.voxel.iterator.intersecting.CountVoxelsIntersectingBounded;
import org.anchoranalysis.image.voxel.iterator.intersecting.IterateVoxelsIntersectingBounded;
import org.anchoranalysis.image.voxel.iterator.predicate.PredicateTwoBytes;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.Point3i;

public class CountVoxelsIntersectingObjects {
    public static boolean hasIntersectingVoxels(ObjectMask object1, ObjectMask object2) {
        PredicateTwoBytes predicate = CountVoxelsIntersectingObjects.voxelInBothObjects(object1, object2);
        Optional<Point3i> firstPoint = IterateVoxelsIntersectingBounded.withTwoBuffersUntil(object1.boundedVoxels(), object2.boundedVoxels(), predicate.deriveUnsignedBytePredicate());
        return firstPoint.isPresent();
    }

    public static int countIntersectingVoxels(ObjectMask object1, ObjectMask object2) {
        return CountVoxelsIntersectingBounded.countByte(object1.boundedVoxels(), object2.boundedVoxels(), CountVoxelsIntersectingObjects.voxelInBothObjects(object1, object2));
    }

    private static PredicateTwoBytes voxelInBothObjects(ObjectMask object1, ObjectMask object2) {
        byte byteOn1 = object1.binaryValuesByte().getOn();
        byte byteOn2 = object2.binaryValuesByte().getOn();
        return (first, second) -> first == byteOn1 && second == byteOn2;
    }

    private CountVoxelsIntersectingObjects() {
    }
}

