/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.intersecting;

import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

final class Intersection {
    private final BoundingBox intersectingBox;
    private final Point3i relative;

    public static Intersection create(BoundingBox box1, BoundingBox box2, BoundingBox boxIntersect) {
        Point3i relativeIntersectionToBox1 = boxIntersect.relativePositionTo(box1);
        Point3i relativeBox2ToBox1 = Point3i.immutableSubtract((ReadableTuple3i)box1.cornerMin(), (ReadableTuple3i)box2.cornerMin());
        return new Intersection(BoundingBox.createReuse((ReadableTuple3i)relativeIntersectionToBox1, (Extent)boxIntersect.extent()), relativeBox2ToBox1);
    }

    public BoundingBox intersectingBox() {
        return this.intersectingBox;
    }

    public Point3i relative() {
        return this.relative;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Intersection)) {
            return false;
        }
        Intersection other = (Intersection)o;
        BoundingBox this$intersectingBox = this.intersectingBox();
        BoundingBox other$intersectingBox = other.intersectingBox();
        if (this$intersectingBox == null ? other$intersectingBox != null : !this$intersectingBox.equals(other$intersectingBox)) {
            return false;
        }
        Point3i this$relative = this.relative();
        Point3i other$relative = other.relative();
        return !(this$relative == null ? other$relative != null : !this$relative.equals(other$relative));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BoundingBox $intersectingBox = this.intersectingBox();
        result = result * 59 + ($intersectingBox == null ? 43 : $intersectingBox.hashCode());
        Point3i $relative = this.relative();
        result = result * 59 + ($relative == null ? 43 : $relative.hashCode());
        return result;
    }

    public String toString() {
        return "Intersection(intersectingBox=" + this.intersectingBox() + ", relative=" + this.relative() + ")";
    }

    private Intersection(BoundingBox intersectingBox, Point3i relative) {
        this.intersectingBox = intersectingBox;
        this.relative = relative;
    }
}

