/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.intersecting;

import java.util.Optional;
import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsBoundingBox;
import org.anchoranalysis.image.voxel.iterator.intersecting.CheckMask;
import org.anchoranalysis.image.voxel.iterator.intersecting.Intersection;
import org.anchoranalysis.image.voxel.iterator.predicate.PredicateBufferBinary;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinary;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class IterateVoxelsIntersectingBounded {
    public static <T> void withTwoBuffers(BoundedVoxels<T> voxels1, BoundedVoxels<T> voxels2, ProcessBufferBinary<T, T> process) {
        Optional<Intersection> intersection = IterateVoxelsIntersectingBounded.findIntersection(voxels1, voxels2);
        if (intersection.isPresent()) {
            IterateVoxelsBoundingBox.withTwoBuffers(intersection.get().intersectingBox(), (ReadableTuple3i)intersection.get().relative(), voxels1.voxels(), voxels2.voxels(), process);
        }
    }

    public static void withTwoBuffers(Voxels<UnsignedByteBuffer> maskGlobal, byte onMaskGlobal, BoundedVoxels<UnsignedByteBuffer> voxels1, BoundedVoxels<UnsignedByteBuffer> voxels2, ProcessBufferBinary<UnsignedByteBuffer, UnsignedByteBuffer> process) {
        Optional<Intersection> intersection = IterateVoxelsIntersectingBounded.findIntersection(voxels1, voxels2);
        if (intersection.isPresent()) {
            IterateVoxelsBoundingBox.withThreeBuffers(intersection.get().intersectingBox(), (ReadableTuple3i)intersection.get().relative(), voxels1.boundingBox().cornerMin(), voxels1.voxels(), voxels2.voxels(), maskGlobal, new CheckMask(process, onMaskGlobal));
        }
    }

    public static <T> Optional<Point3i> withTwoBuffersUntil(BoundedVoxels<T> voxels1, BoundedVoxels<T> voxels2, PredicateBufferBinary<T> predicate) {
        Optional<Intersection> intersection = IterateVoxelsIntersectingBounded.findIntersection(voxels1, voxels2);
        if (intersection.isPresent()) {
            return IterateVoxelsBoundingBox.withTwoBuffersUntil(intersection.get().intersectingBox(), (ReadableTuple3i)intersection.get().relative(), voxels1.voxels(), voxels2.voxels(), predicate);
        }
        return Optional.empty();
    }

    private static <T> Optional<Intersection> findIntersection(BoundedVoxels<T> voxels1, BoundedVoxels<T> voxels2) {
        Optional boxIntersection = voxels1.boundingBox().intersection().with(voxels2.boundingBox());
        return boxIntersection.map(box -> Intersection.create(voxels1.boundingBox(), voxels2.boundingBox(), box));
    }

    private IterateVoxelsIntersectingBounded() {
    }
}

