/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.neighbor;

import java.util.Optional;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessChangedPointAbsoluteMasked;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsolute;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsoluteWithSlidingBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.WithinExtent;
import org.anchoranalysis.image.voxel.iterator.neighbor.WithinObjectMask;
import org.anchoranalysis.image.voxel.iterator.neighbor.WrapAbsoluteAsMasked;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

public class ProcessVoxelNeighborFactory {
    public static <T> ProcessVoxelNeighbor<T> within(Optional<ObjectMask> containingMask, Extent extentFallback, ProcessVoxelNeighborAbsolute<T> process) {
        return containingMask.map(mask -> ProcessVoxelNeighborFactory.withinMask(mask, process)).orElseGet(() -> ProcessVoxelNeighborFactory.withinExtent(extentFallback, process));
    }

    public static <T> ProcessVoxelNeighbor<T> withinExtent(ProcessVoxelNeighborAbsoluteWithSlidingBuffer<T> process) {
        return ProcessVoxelNeighborFactory.withinExtent(process.extent(), process);
    }

    public static <T> ProcessVoxelNeighbor<T> withinMask(ObjectMask object, ProcessChangedPointAbsoluteMasked<T> process) {
        return new WithinObjectMask<T>(process, object);
    }

    public static <T> ProcessVoxelNeighbor<T> withinMask(ObjectMask object, ProcessVoxelNeighborAbsolute<T> process) {
        return new WithinObjectMask<T>(new WrapAbsoluteAsMasked<T>(process), object);
    }

    private static <T> ProcessVoxelNeighbor<T> withinExtent(Extent extent, ProcessVoxelNeighborAbsolute<T> process) {
        return new WithinExtent<T>(extent, process);
    }

    private ProcessVoxelNeighborFactory() {
    }
}

