/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.neighbor;

import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsolute;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;

final class WithinExtent<T>
implements ProcessVoxelNeighbor<T> {
    private final Extent extent;
    private final ProcessVoxelNeighborAbsolute<T> processAbsolutePoint;
    private Point3i point;

    @Override
    public void initSource(Point3i point, int sourceValue, int sourceOffsetXY) {
        this.point = point;
        this.processAbsolutePoint.initSource(sourceValue, sourceOffsetXY);
    }

    @Override
    public void processPoint(int xChange, int yChange) {
        int x1 = this.point.x() + xChange;
        int y1 = this.point.y() + yChange;
        if (x1 < 0 || x1 >= this.extent.x() || y1 < 0 || y1 >= this.extent.y()) {
            return;
        }
        this.processAbsolutePoint.processPoint(xChange, yChange, x1, y1);
    }

    @Override
    public boolean notifyChangeZ(int zChange) {
        int z1 = this.point.z() + zChange;
        if (!this.extent.containsZ(z1)) {
            return false;
        }
        this.processAbsolutePoint.notifyChangeZ(zChange, z1);
        return true;
    }

    @Override
    public T collectResult() {
        return this.processAbsolutePoint.collectResult();
    }

    public WithinExtent(Extent extent, ProcessVoxelNeighborAbsolute<T> processAbsolutePoint) {
        this.extent = extent;
        this.processAbsolutePoint = processAbsolutePoint;
    }
}

