/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.neighbor.kernel;

import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsBoundingBox;
import org.anchoranalysis.image.voxel.iterator.predicate.PredicateKernelPointCursor;
import org.anchoranalysis.image.voxel.iterator.process.ProcessKernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.Kernel;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.LocalSlices;
import org.anchoranalysis.spatial.box.BoundingBox;

public class IterateKernelHelper {
    public static void overAll(Kernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, KernelApplicationParameters parameters, ProcessKernelPointCursor processor) {
        AddLocalSlicesProcessor process = new AddLocalSlicesProcessor(kernel, voxels, processor, parameters.isUseZ());
        IterateVoxelsAll.withCursor(voxels, parameters, process);
    }

    public static void overBox(Kernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, BoundingBox box, KernelApplicationParameters parameters, ProcessKernelPointCursor processor) throws OperationFailedException {
        IterateKernelHelper.checkBoxInsideVoxels(voxels, box);
        AddLocalSlicesProcessor processorWithSlices = new AddLocalSlicesProcessor(kernel, voxels, processor, parameters.isUseZ());
        IterateVoxelsBoundingBox.withCursor(voxels, box, parameters, processorWithSlices);
    }

    public static boolean overBoxUntil(Kernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, BoundingBox box, KernelApplicationParameters parameters, PredicateKernelPointCursor predicate) throws OperationFailedException {
        IterateKernelHelper.checkBoxInsideVoxels(voxels, box);
        AddLocalSlicesPredicate predicateWithSlices = new AddLocalSlicesPredicate(kernel, voxels, predicate, parameters.isUseZ());
        return IterateVoxelsBoundingBox.withCursorUntil(voxels, box, parameters, predicateWithSlices);
    }

    private static void checkBoxInsideVoxels(BinaryVoxels<UnsignedByteBuffer> voxels, BoundingBox box) throws OperationFailedException {
        if (!voxels.extent().contains(box)) {
            throw new OperationFailedException(String.format("Bounding-box (%s) must be contained within extent (%s)", box, voxels.extent()));
        }
    }

    IterateKernelHelper() {
    }

    private static class AddLocalSlicesProcessor
    extends AddSlices
    implements ProcessKernelPointCursor {
        private final ProcessKernelPointCursor processor;

        public AddLocalSlicesProcessor(Kernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, ProcessKernelPointCursor processor, boolean useZ) {
            super(kernel, voxels, useZ);
            this.processor = processor;
        }

        @Override
        public void notifyChangeSlice(int z) {
            this.notifyZChangeToKernel(z);
            this.processor.notifyChangeSlice(z);
        }

        @Override
        public void process(KernelPointCursor point) {
            this.processor.process(point);
        }
    }

    private static class AddLocalSlicesPredicate
    extends AddSlices
    implements PredicateKernelPointCursor {
        private final PredicateKernelPointCursor predicate;

        public AddLocalSlicesPredicate(Kernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, PredicateKernelPointCursor predicate, boolean useZ) {
            super(kernel, voxels, useZ);
            this.predicate = predicate;
        }

        @Override
        public void notifyChangeSlice(int z) {
            this.notifyZChangeToKernel(z);
            this.predicate.notifyChangeSlice(z);
        }

        @Override
        public boolean test(KernelPointCursor point) {
            return this.predicate.test(point);
        }
    }

    private static abstract class AddSlices {
        private final Kernel kernel;
        private final BinaryVoxels<UnsignedByteBuffer> voxels;
        private final int slicesNeeded;

        protected AddSlices(Kernel kernel, BinaryVoxels<UnsignedByteBuffer> voxels, boolean useZ) {
            this.kernel = kernel;
            this.voxels = voxels;
            this.slicesNeeded = useZ ? kernel.getSize() : 1;
        }

        protected void notifyZChangeToKernel(int z) {
            this.kernel.notifyBuffer(new LocalSlices(z, this.slicesNeeded, this.voxels.voxels()), z);
        }
    }
}

